/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.spi;

import java.io.Closeable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.remoting.CloseHandler;
import org.jboss.remoting.HandleableCloseable;
import org.jboss.remoting.spi.SpiUtils;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHandleableCloseable<T>
implements HandleableCloseable<T> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.remoting.resource");
    protected final Executor executor;
    private final Object closeLock = new Object();
    private final AtomicBoolean closed = new AtomicBoolean();
    private Set<CloseHandler<? super T>> closeHandlers;
    private static final boolean LEAK_DEBUGGING;
    private final StackTraceElement[] backtrace;

    protected AbstractHandleableCloseable(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.executor = executor;
        this.backtrace = LEAK_DEBUGGING ? new Throwable().getStackTrace() : null;
    }

    protected boolean isOpen() {
        return !this.closed.get();
    }

    protected void closeAction() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            log.trace("Closed %s", (Object)this);
            Object object = this.closeLock;
            synchronized (object) {
                if (this.closeHandlers != null) {
                    for (final CloseHandler<? super T> closeHandler : this.closeHandlers) {
                        try {
                            this.executor.execute(new Runnable(){

                                public void run() {
                                    SpiUtils.safeHandleClose(closeHandler, AbstractHandleableCloseable.this);
                                }
                            });
                        }
                        catch (RejectedExecutionException ree) {
                            SpiUtils.safeHandleClose(closeHandler, this);
                        }
                    }
                    this.closeHandlers = null;
                }
            }
            this.closeAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleableCloseable.Key addCloseHandler(final CloseHandler<? super T> handler) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closeHandlers == null) {
                this.closeHandlers = new HashSet<CloseHandler<? super T>>();
            }
            this.closeHandlers.add(handler);
            return new HandleableCloseable.Key(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void remove() {
                    Object object = AbstractHandleableCloseable.this.closeLock;
                    synchronized (object) {
                        Set closeHandlers = AbstractHandleableCloseable.this.closeHandlers;
                        if (closeHandlers != null) {
                            closeHandlers.remove(handler);
                        }
                    }
                }
            };
        }
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (this.isOpen()) {
                if (LEAK_DEBUGGING) {
                    LeakThrowable t = new LeakThrowable();
                    t.setStackTrace(this.backtrace);
                    log.warn((Throwable)t, "Leaked a %s instance: %s", (Object)this.getClass().getName(), (Object)this);
                } else {
                    log.warn("Leaked a %s instance: %s", (Object)this.getClass().getName(), (Object)this);
                }
                IoUtils.safeClose((Closeable)this);
            }
        }
    }

    static {
        boolean b = false;
        try {
            b = Boolean.parseBoolean(AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jboss.remoting.leakdebugging", "false");
                }
            }));
        }
        catch (SecurityException se) {
            b = false;
        }
        LEAK_DEBUGGING = b;
    }

    private static final class LeakThrowable
    extends Throwable {
        public String toString() {
            return "a leaked reference";
        }
    }
}

