/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.net.URI;
import java.net.URISyntaxException;

public final class ServiceURI {
    public static final String SCHEME = "jrs";

    private ServiceURI() {
    }

    public static boolean isRemotingServiceUri(URI uri) {
        return SCHEME.equals(uri.getScheme()) && uri.isOpaque();
    }

    public static String getServiceType(URI uri) throws IllegalArgumentException {
        if (!ServiceURI.isRemotingServiceUri(uri)) {
            throw new IllegalArgumentException("Not a valid remoting service URI");
        }
        String ssp = uri.getSchemeSpecificPart();
        int firstColon = ssp.indexOf(58);
        String serviceType = firstColon == -1 ? ssp : ssp.substring(0, firstColon);
        return serviceType;
    }

    public static String getGroupName(URI uri) throws IllegalArgumentException {
        if (!ServiceURI.isRemotingServiceUri(uri)) {
            throw new IllegalArgumentException("Not a valid remoting service URI");
        }
        String ssp = uri.getSchemeSpecificPart();
        int firstColon = ssp.indexOf(58);
        if (firstColon == -1) {
            return "";
        }
        int secondColon = ssp.indexOf(58, firstColon + 1);
        String groupName = secondColon == -1 ? ssp.substring(firstColon + 1) : ssp.substring(firstColon + 1, secondColon);
        return groupName;
    }

    public static String getEndpointName(URI uri) throws IllegalArgumentException {
        if (!ServiceURI.isRemotingServiceUri(uri)) {
            throw new IllegalArgumentException("Not a valid remoting service URI");
        }
        String ssp = uri.getSchemeSpecificPart();
        int firstColon = ssp.indexOf(58);
        if (firstColon == -1) {
            return "";
        }
        int secondColon = ssp.indexOf(58, firstColon + 1);
        if (secondColon == -1) {
            return "";
        }
        int thirdColon = ssp.indexOf(58, secondColon + 1);
        String endpointName = thirdColon == -1 ? ssp.substring(secondColon + 1) : ssp.substring(secondColon + 1, thirdColon);
        return endpointName;
    }

    public static URI create(String serviceType, String groupName, String endpointName) {
        try {
            StringBuilder builder = new StringBuilder(serviceType.length() + groupName.length() + endpointName.length() + 2);
            if (serviceType != null && serviceType.length() > 0) {
                builder.append(serviceType);
            }
            builder.append(':');
            if (groupName != null && groupName.length() > 0) {
                builder.append(groupName);
            }
            builder.append(':');
            if (endpointName != null && endpointName.length() > 0) {
                builder.append(endpointName);
            }
            return new URI(SCHEME, builder.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("URI syntax exception should not be possible here", e);
        }
    }
}

