/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reloaded.shrinkwrap.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.reloaded.shrinkwrap.api.ShrinkWrapDeployer;
import org.jboss.reloaded.shrinkwrap.impl.ArchiveDeployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.vfs.TempFileProvider;

public final class ShrinkWrapDeployerImpl
implements ShrinkWrapDeployer {
    private static final Logger log = Logger.getLogger(ShrinkWrapDeployerImpl.class);
    private final MainDeployer deployer;
    private final TempFileProvider tempFileProvider;
    private final Map<Archive<?>, ArchiveDeployment> deployments = new HashMap();

    public ShrinkWrapDeployerImpl(@Inject MainDeployer deployer, @Inject TempFileProvider tempFileProvider) {
        if (deployer == null) {
            throw new IllegalArgumentException("deployer must be specified");
        }
        if (tempFileProvider == null) {
            throw new IllegalArgumentException("tempFileProvider must be specified");
        }
        this.deployer = deployer;
        this.tempFileProvider = tempFileProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(Archive<?> ... archives) throws IllegalArgumentException, DeploymentException {
        if (archives == null) {
            throw new IllegalArgumentException("Archives must be specified (even if empty)");
        }
        ArrayList<ArchiveDeployment> newDeployments = new ArrayList<ArchiveDeployment>();
        for (Archive<?> archive : archives) {
            newDeployments.add(new ArchiveDeployment(archive, this.tempFileProvider));
        }
        ShrinkWrapDeployerImpl shrinkWrapDeployerImpl = this;
        synchronized (shrinkWrapDeployerImpl) {
            MainDeployer deployer = this.deployer;
            ArrayList<ArchiveDeployment> deploymentsToAdd = new ArrayList<ArchiveDeployment>(archives.length);
            for (ArchiveDeployment deployment : newDeployments) {
                Archive<?> currentArchive = deployment.getArchive();
                if (this.deployments.containsKey(currentArchive)) {
                    log.warnf("Ignoring request to deploy already-deployed archive: %s", new Object[]{currentArchive});
                    try {
                        deployment.getHandle().close();
                    }
                    catch (IOException e) {
                        log.warnf((Throwable)e, "Could not close handle for mounted archive %s", new Object[]{currentArchive});
                    }
                }
                try {
                    deployer.addDeployment((Deployment)deployment);
                }
                catch (DeploymentException de) {
                    log.warnf((Throwable)de, "Error in adding deployment for archive %s; reverting out the previous deployments", new Object[]{currentArchive});
                    this.removeDeployments(deploymentsToAdd);
                    throw de;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Adding archive for deployment: %s", new Object[]{currentArchive});
                }
                deploymentsToAdd.add(deployment);
            }
            deployer.process();
            try {
                deployer.checkComplete();
            }
            catch (DeploymentException de) {
                log.warn((Object)"Error in processing deployments; reverting all archives requested for deployment", (Throwable)de);
                this.removeDeployments(deploymentsToAdd);
                throw de;
            }
            for (ArchiveDeployment deploymentAdded : deploymentsToAdd) {
                this.deployments.put(deploymentAdded.getArchive(), deploymentAdded);
            }
            if (log.isDebugEnabled()) {
                log.debugf("Deployed: %s", new Object[]{deploymentsToAdd});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy(Archive<?> ... archives) throws IllegalArgumentException, DeploymentException {
        if (archives == null) {
            throw new IllegalArgumentException("Archives must be specified (even if empty)");
        }
        ShrinkWrapDeployerImpl shrinkWrapDeployerImpl = this;
        synchronized (shrinkWrapDeployerImpl) {
            ArrayList<ArchiveDeployment> deploymentsToRemove = new ArrayList<ArchiveDeployment>(archives.length);
            for (Archive<?> archive : archives) {
                ArchiveDeployment deployment = this.deployments.get(archive);
                if (deployment == null) {
                    log.warnf("No deployment has been made for archive %s; ignoring", new Object[]{archive.toString()});
                    continue;
                }
                deploymentsToRemove.add(deployment);
            }
            this.removeDeployments(deploymentsToRemove);
        }
    }

    private void removeDeployments(Collection<ArchiveDeployment> deployments) throws DeploymentException {
        assert (deployments != null) : "deployments must not be null";
        MainDeployer deployer = this.deployer;
        for (ArchiveDeployment deployment : deployments) {
            try {
                deployer.removeDeployment((Deployment)deployment);
            }
            catch (DeploymentException de) {
                log.warnf((Throwable)de, "Could not remove deployment %s", new Object[]{deployment});
            }
        }
        DeploymentException cachedException = null;
        deployer.process();
        try {
            deployer.checkComplete();
        }
        catch (DeploymentException de) {
            log.warn((Object)"Problem in Main Deployer while removing pending deployments", (Throwable)de);
            cachedException = de;
        }
        for (ArchiveDeployment deployment : deployments) {
            block10: {
                try {
                    deployment.getHandle().close();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debugf((Throwable)e, "Could not close the mounted %s", new Object[]{deployment.getArchive()});
                }
            }
            this.deployments.remove(deployment.getArchive());
        }
        if (cachedException != null) {
            throw cachedException;
        }
    }
}

