/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jirabot.repo;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.jboss.jirabot.IssueCache;
import org.jboss.jirabot.JiraInfo;
import org.jboss.jirabot.repo.RepositoryCache;

public class RepositoryParser {
    private static final String[] issueProperties = new String[]{"Key", "Type", "Status", "Priority", "Assignee", "Reporter", "Votes", "Watchers"};
    private static final String cellXpathPattern = ".//td[b[normalize-space()='%s:']]/following-sibling::td[1]";
    private static final int MIN_JIRA_PREFIX_LENGTH = 3;
    private final WebClient wc;
    private IssueCache issueCache = IssueCache.getSingleton();
    private RepositoryCache repositoryCache = RepositoryCache.getSingleton();

    public RepositoryParser() {
        this.wc = new WebClient(BrowserVersion.FIREFOX_3);
        this.wc.setCssEnabled(false);
        this.wc.setJavaScriptEnabled(false);
    }

    public JiraInfo getJiraInfo(String jiraID, boolean skipCache) {
        jiraID = jiraID.toUpperCase();
        JiraInfo resultItem = null;
        Object reply = null;
        if (!skipCache) {
            resultItem = this.issueCache.getItem(jiraID);
        }
        if (resultItem == null) {
            resultItem = this.getJiraInfo(jiraID);
            this.issueCache.putItem(jiraID, resultItem);
        }
        return resultItem;
    }

    public boolean hasIgnoredPrefix(String jiraID) {
        String[] parts = jiraID.split("-");
        if (parts[0].length() < 3) {
            return false;
        }
        return this.repositoryCache.isIgnoredPrefix(parts[0]);
    }

    private JiraInfo getJiraInfo(String jiraID) {
        JiraInfo jiraInfo = null;
        String url = null;
        String reply = "";
        String[] parts = jiraID.split("-");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid jira ID: " + jiraID);
        }
        String repository = this.repositoryCache.getUrl(parts[0]);
        if (repository == null) {
            reply = "Do not know URL for issue " + jiraID;
            jiraInfo = new JiraInfo(reply, url);
            return jiraInfo;
        }
        url = repository + "-" + parts[1];
        HtmlPage page = null;
        try {
            page = (HtmlPage)this.wc.getPage(url);
        }
        catch (Exception ex) {
            reply = "Problem communicating with " + url + " for " + jiraID + ": " + ex;
            jiraInfo = new JiraInfo(reply, url);
            return jiraInfo;
        }
        String title = page.getTitleText();
        title = title.replace(" - RHQ Project JIRA", "");
        title = title.replace(" - jboss.org JIRA", "");
        if (title.toUpperCase().contains("login required")) {
            reply = "JIRA issue " + jiraID + " is secured. I can't login to see this issue.";
        } else if (title.toUpperCase().contains("ISSUE DOES NOT EXIST")) {
            try {
                String hostName = new URL(url).getHost();
                reply = "JIRA at " + hostName + " reports that " + jiraID + " does not exist.";
            }
            catch (MalformedURLException murle) {
                reply = "Bad URL for " + jiraID + ": " + url;
            }
        } else {
            HtmlElement infoTable;
            reply = title;
            if (title.toUpperCase().startsWith("[#" + jiraID + "]") && (infoTable = page.getElementById("issuedetails")) != null) {
                HashMap<String, String> details = new HashMap<String, String>();
                for (String key : issueProperties) {
                    String xPath = String.format(cellXpathPattern, key);
                    HtmlTableCell td = (HtmlTableCell)infoTable.getFirstByXPath(xPath);
                    if (null == td) continue;
                    details.put(key, td.getTextContent().trim());
                }
                String status = (String)details.get("Status");
                String priority = (String)details.get("Priority");
                String assignee = (String)details.get("Assignee");
                reply = reply + String.format(" [%s, %s, %s]", status, priority, assignee);
            }
        }
        jiraInfo = new JiraInfo(reply, url);
        return jiraInfo;
    }
}

