/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jirabot.repo;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jirabot.repo.RepositoryCacheLoader;
import org.jboss.jirabot.repo.StaticRepositoryCacheLoader;

public class RepositoryCache {
    private RepositoryCacheLoader loader;
    private final Map<String, Site> cache = Collections.synchronizedMap(new HashMap());
    private final Set<String> ignoredPrefixes = Collections.synchronizedSet(new HashSet());
    private String defaultUrlPrefix;
    private static final RepositoryCache singleton = new RepositoryCache();

    private RepositoryCache() {
        this.setRepositoryCacheLoader(new StaticRepositoryCacheLoader());
    }

    public static RepositoryCache getSingleton() {
        return singleton;
    }

    public void setRepositoryCacheLoader(RepositoryCacheLoader loader) {
        this.loader = loader;
        loader.initialize();
        this.reloadMappings();
    }

    public void reloadMappings() {
        Map<String, Site> mappings = this.loader.loadMappings();
        for (Map.Entry<String, Site> siteMapping : mappings.entrySet()) {
            this.cache.put(siteMapping.getKey().toUpperCase(), siteMapping.getValue());
        }
        this.defaultUrlPrefix = this.loader.getDefaultUrlPrefix();
        Set<String> ignoredPrefixes = this.loader.loadIgnoredPrefixes();
        this.ignoredPrefixes.clear();
        this.ignoredPrefixes.addAll(ignoredPrefixes);
    }

    public String getUrl(String keyPrefix) {
        Site siteForKey = this.cache.get(keyPrefix.toUpperCase());
        if (siteForKey == null) {
            return this.defaultUrlPrefix + keyPrefix;
        }
        return siteForKey.getUrl();
    }

    public boolean isIgnoredPrefix(String keyPrefix) {
        return this.ignoredPrefixes.contains(keyPrefix);
    }

    public static class Site {
        private final String url;
        private final String username;
        private final String password;

        public Site(String url) {
            this(url, null, null);
        }

        public Site(String url, String username, String password) {
            this.url = url;
            this.username = username;
            this.password = password;
        }

        public boolean requiresAuthentication() {
            return this.username != null || this.password != null;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

