/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jirabot;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraInfo {
    private String response;
    private String url;
    private long lastTimeRequested;
    private Map<String, Long> lastShownAtChannel = new HashMap<String, Long>();

    public Map<String, Long> getLastShownAtChannelMap() {
        return this.lastShownAtChannel;
    }

    public JiraInfo(String response) {
        this.response = response;
        this.lastTimeRequested = System.currentTimeMillis();
    }

    public JiraInfo(String response, String url) {
        this.response = response;
        this.url = url;
        this.lastTimeRequested = System.currentTimeMillis();
    }

    public boolean isStale() {
        return this.isStale(System.currentTimeMillis());
    }

    public boolean isStale(long currentTimeMillis) {
        long timeInCache = currentTimeMillis - this.lastTimeRequested;
        return timeInCache > 0x6DDD00L;
    }

    public String getResponse() {
        this.lastTimeRequested = System.currentTimeMillis();
        return this.response;
    }

    public String getURL() {
        return this.url;
    }

    public String toString(boolean showURL) {
        if (showURL) {
            return String.format("%s; %s", this.getResponse(), this.getURL());
        }
        return this.getResponse();
    }

    public String toString() {
        return this.getResponse();
    }

    boolean wasShownInLastSeconds(String shownFor, int seconds, long curTimeMS) {
        Long lastShown = this.getLastShownAtChannelMap().get(shownFor);
        if (null == lastShown) {
            return false;
        }
        return lastShown + (long)(seconds * 1000) > curTimeMS;
    }

    public void setLastShownAtChannel(String shownFor, long curTimeMS) {
        this.lastShownAtChannel.put(shownFor, curTimeMS);
    }
}

