/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jirabot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.jirabot.IssueCache;
import org.jboss.jirabot.JiraBotException;
import org.jboss.jirabot.JiraInfo;
import org.jboss.jirabot.repo.RepositoryParser;
import org.jibble.pircbot.IrcException;
import org.jibble.pircbot.NickAlreadyInUseException;
import org.jibble.pircbot.PircBot;

public class JiraBot
extends PircBot {
    private static final String VERSION = "1.0.05";
    private static final String PROJECT_DOC_URL = "https://docspace.corp.redhat.com/clearspace/docs/DOC-20386";
    private static final Pattern JIRA_KEY_PATTERN = Pattern.compile("([A-Z]{3,}\\-[0-9]+(?!\\.))");
    private static final int MAX_JIRA_IDS_PER_REQUEST = 3;
    private IssueCache issueCache = IssueCache.getSingleton();
    private RepositoryParser repositoryParser = new RepositoryParser();
    int quitPassword = new Random().nextInt(1000);
    final String BOT_NICK = "JiraBot";
    final String USUAL_NICK = "jirabot";
    private boolean shuttingDown = false;

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    private void setShuttingDown(boolean shuttingDown) {
        this.shuttingDown = shuttingDown;
    }

    public JiraBot() {
        this.setName("JiraBot");
        System.out.println("\n\n  *** QUIT PASSWORD: " + this.quitPassword + " ***\n");
        try {
            FileUtils.writeStringToFile((File)new File("quit.txt"), (String)("" + this.quitPassword));
        }
        catch (IOException ex) {
            Logger.getLogger(JiraBot.class.getName()).log(Level.SEVERE, "Failed storing quit password: " + ex.getMessage(), ex);
        }
    }

    void start() throws JiraBotException {
        this.connect();
    }

    private void connect() throws JiraBotException {
        if (this.isConnected()) {
            throw new JiraBotException("Allready connected.");
        }
        try {
            this.connect("porky.stuttgart.redhat.com");
            this.joinChannel("#some");
            this.joinChannel("#embjopr");
            this.joinChannel("#jbossas");
            this.joinChannel("#jbossportal");
            this.joinChannel("#jbosssoaqa");
            this.joinChannel("#jboss-on");
        }
        catch (IOException ex) {
            this.log(ex.toString());
            throw new JiraBotException("Can't connect: " + ex.getMessage(), ex);
        }
        catch (NickAlreadyInUseException ex) {
            this.log("Nick already in use. " + ex.getMessage());
            throw new JiraBotException("Nick already in use. " + ex.getMessage());
        }
        catch (IrcException ex) {
            this.log(ex.toString());
            throw new JiraBotException("Can't connect: " + ex.getMessage(), ex);
        }
    }

    public void onMessage(String channel, String sender, String login, String hostname, String message) {
        boolean wasCommand = false;
        String msgNormalized = message.trim().toLowerCase();
        boolean startsWithJiraBot = msgNormalized.startsWith("jirabot".toLowerCase());
        boolean startsWithBotNick = msgNormalized.startsWith("JiraBot".toLowerCase());
        if (startsWithJiraBot || startsWithBotNick) {
            int prologEnd = startsWithJiraBot && startsWithBotNick ? Math.max("jirabot".length(), "JiraBot".length()) : (startsWithJiraBot ? "jirabot".length() : "JiraBot".length());
            String command = msgNormalized.substring(prologEnd);
            command = StringUtils.removeStart((String)command, (String)":").trim();
            wasCommand = this.handleJiraBotCommand(channel, command, false);
        }
        if (!wasCommand) {
            this.handleJiraRequest(channel, message.trim());
        }
    }

    protected void onPrivateMessage(String sender, String login, String hostname, String message) {
        this.handleJiraBotCommand(sender, message.trim(), true);
    }

    void handleJiraRequest(String from, String request) {
        ArrayList<String> jiraIDs = new ArrayList<String>();
        Matcher jiraIdMatcher = JIRA_KEY_PATTERN.matcher(request);
        while (jiraIdMatcher.find()) {
            jiraIDs.add(jiraIdMatcher.group().toUpperCase());
        }
        if (jiraIDs.size() > 3) {
            this.sendMessage(from, "Don't be obnoxious, I'll answer up to three JIRA requests at a time.");
        } else {
            boolean skipCache = request.contains("refresh");
            boolean noURL = request.contains("nourl");
            long curTimeMS = System.currentTimeMillis();
            for (String jiraID : jiraIDs) {
                if (this.repositoryParser.hasIgnoredPrefix(jiraID)) continue;
                JiraInfo jiraInfo = this.repositoryParser.getJiraInfo(jiraID, skipCache);
                if (jiraInfo.wasShownInLastSeconds(from, 120, curTimeMS)) continue;
                String urlPart = StringUtils.substringAfter((String)jiraInfo.getURL(), (String)"//");
                boolean noURLcur = noURL || request.contains(urlPart);
                String reply = String.format(noURLcur ? "%s" : "%s %s", jiraInfo.getResponse(), jiraInfo.getURL());
                this.sendMessage(from, reply);
                jiraInfo.setLastShownAtChannel(from, curTimeMS);
            }
        }
    }

    boolean handleJiraBotCommand(String from, String command, boolean isFromPrivateMessage) {
        boolean wasValidCommand = false;
        command = command.toLowerCase();
        if (!isFromPrivateMessage && command.startsWith("please leave")) {
            wasValidCommand = true;
            this.sendMessage(from, "Bye everyone. I'll be around; if you miss me later, /invite me.");
            this.partChannel(from, "Persona non grata.");
        } else if (isFromPrivateMessage && command.startsWith("diedie")) {
            wasValidCommand = true;
            this.sendMessage(from, "Gotcha!");
            this.sendMessage("#embjopr", from + " is trying to kill me! Heeelp!");
        } else if (isFromPrivateMessage && command.startsWith("quit " + this.quitPassword)) {
            this.sendMessage(from, "Bye, shutting down.");
            this.setShuttingDown(true);
            this.disconnect();
        } else if (command.startsWith("clearcache")) {
            wasValidCommand = true;
            String clearJiraID = command.substring(10).trim().toUpperCase();
            if ("".equals(clearJiraID)) {
                this.sendMessage(from, "Clearing the cache.");
                this.issueCache.clear();
            } else {
                this.sendMessage(from, "Clearing the cache for " + clearJiraID + ".");
                this.issueCache.removeItem(clearJiraID);
            }
        } else if (command.startsWith("about") || command.startsWith("help")) {
            wasValidCommand = true;
            this.sendMessage(from, "Hi, I'm a bot which brings some useful info about JIRA issues to IRC channels. Version: 1.0.05");
            this.sendMessage(from, "If you want me in your channel, invite me, usually done by typing '/invite JiraBot' in that channel.");
            this.sendMessage(from, "If you don't like me, kick me off. Or say 'jirabot please leave'.");
            this.sendMessage(from, "For more info, see https://docspace.corp.redhat.com/clearspace/docs/DOC-20386");
        }
        return wasValidCommand;
    }

    protected void onInvite(String targetNick, String sourceNick, String sourceLogin, String sourceHostname, String channel) {
        this.joinChannel(channel);
    }

    protected void onPart(String channel, String sender, String login, String hostname) {
        System.out.println("Channels: " + this.getChannels().length + " - " + Arrays.toString(this.getChannels()));
    }

    protected void onDisconnect() {
        if (!this.isShuttingDown()) {
            this.log("Disconnected unintentionally, re-connecting...");
            try {
                this.connect();
            }
            catch (JiraBotException ex) {
                this.log("Re-connect attempt failed: " + ex.getMessage());
            }
        } else {
            this.log("Disconnected intentionally, stopping threads...");
            IssueCache.getSingleton().stopExporyThread();
            this.dispose();
        }
    }
}

