/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jboss.qa.phaser.PhaseDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);
    private static Document doc = null;

    public static void generateReport(Throwable ex, PhaseDefinition phaseDefinition) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
            Element rootElement = XmlUtils.createTestsuiteElement(phaseDefinition, ex);
            doc.appendChild(rootElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            File reportsDir = new File(phaseDefinition.getReportsHandling().getReportsDir());
            File reportFile = new File(reportsDir, "TEST-" + phaseDefinition.getJob().getClass().getSimpleName() + "-" + System.nanoTime() + ".xml");
            reportFile.getParentFile().mkdirs();
            reportFile.createNewFile();
            StreamResult result = new StreamResult(reportFile);
            transformer.transform(source, result);
            log.info("generated report at: " + reportFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Element createTestsuiteElement(PhaseDefinition phaseDefinition, Throwable ex) {
        Element elem = doc.createElement("testsuite");
        Element propsElem = doc.createElement("properties");
        Properties props = System.getProperties();
        if (props != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Element propElement = doc.createElement("property");
                propElement.setAttribute("name", name);
                propElement.setAttribute("value", props.getProperty(name));
                propsElem.appendChild(propElement);
            }
        }
        elem.appendChild(propsElem);
        elem.setAttribute("name", phaseDefinition.getJob().getClass().toString());
        elem.setAttribute("tests", "1");
        elem.setAttribute("skipped", "0");
        elem.setAttribute("failures", "0");
        if (ex == null) {
            elem.setAttribute("errors", "0");
        } else {
            elem.setAttribute("errors", "1");
        }
        elem.appendChild(XmlUtils.createTestCaseElement(phaseDefinition, ex));
        return elem;
    }

    private static Element createTestCaseElement(PhaseDefinition phaseDefinition, Throwable ex) {
        Element elem = doc.createElement("testcase");
        elem.setAttribute("name", phaseDefinition.getMethod().getName());
        elem.setAttribute("classname", phaseDefinition.getJob().getClass().getCanonicalName());
        elem.setAttribute("time", "0");
        if (ex != null) {
            Element failElem = doc.createElement("failure");
            failElem.setAttribute("type", ex.getCause().getClass().getName());
            failElem.setTextContent(ExceptionUtils.getStackTrace((Throwable)ex.getCause()));
            elem.appendChild(failElem);
        }
        return elem;
    }

    private XmlUtils() {
    }
}

