/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseTree;
import org.jboss.qa.phaser.PhaseTreeNode;

public class PhaseTreeBuilder {
    private List<PhaseTreeNode> roots = new ArrayList<PhaseTreeNode>();
    private PhaseTreeNode actualNodeLevel;
    private PhaseTreeNode actualNode;

    public PhaseTreeBuilder addRootPhase(Phase phase) {
        PhaseTreeNode node = new PhaseTreeNode(phase);
        this.actualNodeLevel = null;
        this.actualNode = node;
        this.roots.add(node);
        return this;
    }

    public PhaseTreeBuilder addPhase(Phase phase) {
        if (this.actualNodeLevel == null) {
            return this.addRootPhase(phase);
        }
        PhaseTreeNode node = new PhaseTreeNode(phase);
        this.actualNodeLevel.addChild(node);
        this.actualNode = node;
        return this;
    }

    public PhaseTreeBuilder next() {
        this.actualNodeLevel = this.actualNode;
        return this;
    }

    public PhaseTreeBuilder back() {
        if (this.actualNodeLevel != null) {
            this.actualNode = this.actualNodeLevel;
            this.actualNodeLevel = this.actualNodeLevel.getParent();
        }
        return this;
    }

    public PhaseTree build() {
        return new PhaseTree(this.roots);
    }
}

