/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.util.List;
import org.jboss.qa.phaser.context.Context;
import org.jboss.qa.phaser.context.PropertyAnnotationProcessor;
import org.jboss.qa.phaser.processors.CdiExecutor;
import org.jboss.qa.phaser.registry.InjectAnnotationProcessor;
import org.jboss.qa.phaser.registry.InstanceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Injector {
    private static final Logger log = LoggerFactory.getLogger(Injector.class);

    private Injector() {
    }

    public static void injectFields(InstanceRegistry registry, List<Object> objs) throws Exception {
        for (Object obj : objs) {
            Injector.injectFields(registry, obj);
        }
    }

    public static void injectFields(InstanceRegistry registry, Object obj) throws Exception {
        CdiExecutor.CdiExecutorBuilder cdiExecutorBuilder = CdiExecutor.builder();
        List<Context> ctxs = registry.get(Context.class);
        if (!ctxs.isEmpty()) {
            cdiExecutorBuilder.processor(new PropertyAnnotationProcessor(ctxs.get(0)));
        } else {
            log.warn("Property injection is not activated. You can activate it by adding context into instance registry");
        }
        CdiExecutor cdiExecutor = cdiExecutorBuilder.processor(new InjectAnnotationProcessor(registry)).build();
        cdiExecutor.inject(obj);
    }
}

