/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser.processors;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.qa.phaser.processors.ParameterProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodExecutor {
    private static final Logger log = LoggerFactory.getLogger(MethodExecutor.class);
    private ParameterProcessor defaultProcessor;
    private List<ParameterProcessor> processors;

    public void invokeMethod(Method method, Object target) throws InvocationTargetException, IllegalAccessException {
        try {
            Class<?>[] paramClasses = method.getParameterTypes();
            if (paramClasses.length == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Execute method {}#{}", (Object)target.getClass().getCanonicalName(), (Object)method.getName());
                }
                method.invoke(target, new Object[0]);
                return;
            }
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            ArrayList<List<Object>> params = new ArrayList<List<Object>>(paramClasses.length);
            params.ensureCapacity(paramClasses.length);
            for (int i = 0; i < paramClasses.length; ++i) {
                List<Object> param = Collections.emptyList();
                for (int j = 0; j < paramAnnotations[i].length; ++j) {
                    Annotation annotation = paramAnnotations[i][j];
                    for (ParameterProcessor processor : this.processors) {
                        if (!processor.getAnnotationClass().isAssignableFrom(annotation.getClass())) continue;
                        param = processor.processParameter(paramClasses[i], annotation);
                    }
                }
                if (paramAnnotations[i].length == 0 && this.defaultProcessor != null) {
                    param = this.defaultProcessor.processParameter(paramClasses[i], null);
                }
                params.add(param);
            }
            for (List<Object> methodParams : MethodExecutor.createCartesianProduct(params)) {
                if (log.isDebugEnabled()) {
                    log.debug("Execute method {}#{} with params: {}", new Object[]{target.getClass().getCanonicalName(), method.getName(), methodParams.toArray()});
                }
                method.invoke(target, methodParams.toArray());
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable invoke method " + method.getName() + " in class " + target.getClass().getCanonicalName(), e);
        }
    }

    private static List<List<Object>> createCartesianProduct(List<List<Object>> lists) {
        ArrayList<List<Object>> resultLists = new ArrayList<List<Object>>();
        if (lists.size() == 0) {
            resultLists.add(new ArrayList());
            return resultLists;
        }
        List<Object> firstList = lists.get(0);
        List<List<Object>> remainingLists = MethodExecutor.createCartesianProduct(lists.subList(1, lists.size()));
        for (Object condition : firstList) {
            for (List<Object> remainingList : remainingLists) {
                ArrayList<Object> resultList = new ArrayList<Object>();
                resultList.add(condition);
                resultList.addAll(remainingList);
                resultLists.add(resultList);
            }
        }
        return resultLists;
    }

    MethodExecutor(ParameterProcessor defaultProcessor, List<ParameterProcessor> processors) {
        this.defaultProcessor = defaultProcessor;
        this.processors = processors;
    }

    public static MethodExecutorBuilder builder() {
        return new MethodExecutorBuilder();
    }

    public static class MethodExecutorBuilder {
        private ParameterProcessor defaultProcessor;
        private ArrayList<ParameterProcessor> processors;

        MethodExecutorBuilder() {
        }

        public MethodExecutorBuilder defaultProcessor(ParameterProcessor defaultProcessor) {
            this.defaultProcessor = defaultProcessor;
            return this;
        }

        public MethodExecutorBuilder processor(ParameterProcessor processor) {
            if (this.processors == null) {
                this.processors = new ArrayList();
            }
            this.processors.add(processor);
            return this;
        }

        public MethodExecutorBuilder processors(Collection<? extends ParameterProcessor> processors) {
            if (this.processors == null) {
                this.processors = new ArrayList();
            }
            this.processors.addAll(processors);
            return this;
        }

        public MethodExecutor build() {
            List<ParameterProcessor> processors;
            switch (this.processors == null ? 0 : this.processors.size()) {
                case 0: {
                    processors = Collections.emptyList();
                    break;
                }
                case 1: {
                    processors = Collections.singletonList(this.processors.get(0));
                    break;
                }
                default: {
                    processors = Collections.unmodifiableList(new ArrayList<ParameterProcessor>(this.processors));
                }
            }
            return new MethodExecutor(this.defaultProcessor, processors);
        }

        public String toString() {
            return "MethodExecutor.MethodExecutorBuilder(defaultProcessor=" + this.defaultProcessor + ", processors=" + this.processors + ")";
        }
    }
}

