/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.jboss.qa.phaser.AfterJob;
import org.jboss.qa.phaser.BeforeJob;
import org.jboss.qa.phaser.ErrorReport;
import org.jboss.qa.phaser.ErrorReporter;
import org.jboss.qa.phaser.ExceptionHandling;
import org.jboss.qa.phaser.ExecutionError;
import org.jboss.qa.phaser.ExecutionNode;
import org.jboss.qa.phaser.Injector;
import org.jboss.qa.phaser.registry.InstanceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger log = LoggerFactory.getLogger(Executor.class);
    private List<Object> jobs;
    private List<ExecutionNode> roots;
    private InstanceRegistry registry;

    public Executor(List<Object> jobs, List<ExecutionNode> roots, InstanceRegistry registry) throws Exception {
        this.jobs = jobs;
        this.roots = roots;
        this.registry = registry;
        Injector.injectFields(registry, jobs);
    }

    public void execute() throws Exception {
        LinkedList<ErrorReport> throwAtEnd = new LinkedList<ErrorReport>();
        this.invokeJobMethods(BeforeJob.class);
        LinkedList<ExecutionNode> nodeQueue = new LinkedList<ExecutionNode>(this.roots);
        boolean finalizeState = false;
        while (!nodeQueue.isEmpty()) {
            ExecutionNode node = (ExecutionNode)nodeQueue.poll();
            ExecutionError err = node.execute(finalizeState, this.registry);
            if (err != null) {
                ExceptionHandling eh = err.getExceptionHandling();
                ErrorReport errorReport = new ErrorReport("Exception thrown by phase execution:", err.getThrowable());
                switch (eh.getReport()) {
                    case THROW_AT_END: {
                        throwAtEnd.add(errorReport);
                        break;
                    }
                    case LOG: {
                        ErrorReporter.report(errorReport);
                        break;
                    }
                    default: {
                        log.debug("Exception by phase execution, continue.");
                    }
                }
                if (eh.getExecution() == ExceptionHandling.Execution.IMMEDIATELY_STOP) break;
                if (eh.getExecution() == ExceptionHandling.Execution.FINALIZE) {
                    finalizeState = true;
                }
            }
            nodeQueue.addAll(node.getChildNodes());
        }
        this.invokeJobMethods(AfterJob.class);
        ErrorReporter.finalErrorReport(throwAtEnd);
    }

    private void invokeJobMethods(Class<? extends Annotation> annotationClass) throws Exception {
        for (Object job : this.jobs) {
            for (Method m : job.getClass().getMethods()) {
                Annotation annotation = m.getAnnotation(annotationClass);
                if (annotation == null) continue;
                m.invoke(job, new Object[0]);
            }
        }
    }
}

