/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.qa.phaser.Id;
import org.jboss.qa.phaser.Order;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseValidationException;
import org.jboss.qa.phaser.RunAlways;

public final class PhaseValidator {
    private static Map<Class<?>, Class<?>> primitiveTypeMap = new HashMap();

    private static void validateIdPresence(Phase phase) throws PhaseValidationException {
        for (Method m : phase.getAnnotationClass().getMethods()) {
            if (!m.isAnnotationPresent(Id.class)) continue;
            return;
        }
        throw new PhaseValidationException(Id.class.getName() + " annotation not present for any method of " + phase.getAnnotationClass().getCanonicalName());
    }

    private static void validateOrderType(Phase phase) throws PhaseValidationException {
        for (Method m : phase.getAnnotationClass().getMethods()) {
            Class<?> numberType;
            if (!m.isAnnotationPresent(Order.class)) continue;
            Class<?> orderType = m.getReturnType();
            if (orderType.isPrimitive() && (numberType = primitiveTypeMap.get(orderType)) != null) {
                orderType = numberType;
            }
            if (Number.class.isAssignableFrom(orderType)) continue;
            throw new PhaseValidationException(Order.class.getName() + " method does not return number in " + phase.getAnnotationClass().getCanonicalName());
        }
    }

    private static void validateRunAllwaysType(Phase phase) throws PhaseValidationException {
        for (Method m : phase.getAnnotationClass().getMethods()) {
            if (!m.isAnnotationPresent(RunAlways.class) || m.getReturnType().equals(String.class)) continue;
            throw new PhaseValidationException(RunAlways.class.getName() + " method does not return String in " + phase.getAnnotationClass().getCanonicalName());
        }
    }

    public static void validate(Phase phase) throws PhaseValidationException {
        PhaseValidator.validateIdPresence(phase);
        PhaseValidator.validateOrderType(phase);
        PhaseValidator.validateRunAllwaysType(phase);
    }

    private PhaseValidator() {
    }

    static {
        primitiveTypeMap.put(Integer.TYPE, Integer.class);
        primitiveTypeMap.put(Long.TYPE, Long.class);
        primitiveTypeMap.put(Double.TYPE, Double.class);
        primitiveTypeMap.put(Float.TYPE, Float.class);
        primitiveTypeMap.put(Byte.TYPE, Byte.class);
        primitiveTypeMap.put(Short.TYPE, Short.class);
    }
}

