/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.qa.phaser.ExecutionNode;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseDefinition;
import org.jboss.qa.phaser.PhaseDefinitionProcessorBuilder;
import org.jboss.qa.phaser.PhaseValidationException;
import org.jboss.qa.phaser.PhaseValidator;

public class PhaseTreeNode {
    private PhaseTreeNode parent;
    private List<PhaseTreeNode> childNodes = new ArrayList<PhaseTreeNode>();
    private Phase phase;
    private List<PhaseDefinition> phaseDefinitions;

    public PhaseTreeNode(Phase phase) {
        this.phase = phase;
    }

    public void addChild(PhaseTreeNode childNode) {
        childNode.parent = this;
        this.childNodes.add(childNode);
    }

    public void validate() throws PhaseValidationException {
        PhaseValidator.validate(this.phase);
        for (PhaseTreeNode node : this.childNodes) {
            node.validate();
        }
    }

    public void buildPhaseDefinitions(List<Object> jobs) throws Exception {
        this.phaseDefinitions = new LinkedList<PhaseDefinition>();
        for (Object job : jobs) {
            this.phaseDefinitions.addAll(this.phase.findAllDefinitions(job));
        }
        Collections.sort(this.phaseDefinitions);
        for (PhaseTreeNode node : this.childNodes) {
            node.buildPhaseDefinitions(jobs);
        }
    }

    public List<ExecutionNode> buildExecutionTree(PhaseDefinition<?> parent) {
        LinkedList<ExecutionNode> executionNodes = new LinkedList<ExecutionNode>();
        if (this.phaseDefinitions.isEmpty()) {
            for (PhaseTreeNode node : this.childNodes) {
                executionNodes.addAll(node.buildExecutionTree(null));
            }
        } else {
            for (PhaseDefinition pd : this.phaseDefinitions) {
                if (!this.isAcceptable(parent, pd)) continue;
                ExecutionNode executionNode = new ExecutionNode(pd, ((PhaseDefinitionProcessorBuilder)this.phase.getPhaseDefinitionBuilder()).buildProcessor(pd.getAnnotation(), pd.getMethod()));
                for (PhaseTreeNode node : this.childNodes) {
                    executionNode.addChildNodes(node.buildExecutionTree(pd));
                }
                executionNodes.add(executionNode);
            }
        }
        return executionNodes;
    }

    private boolean isAcceptable(PhaseDefinition<?> parent, PhaseDefinition<?> candidate) {
        return candidate.getParentId() == null || parent != null && candidate.getParentId().equals(parent.getId());
    }

    public PhaseTreeNode getParent() {
        return this.parent;
    }

    public List<PhaseTreeNode> getChildNodes() {
        return this.childNodes;
    }

    public Phase getPhase() {
        return this.phase;
    }
}

