/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.qa.phaser.Id;
import org.jboss.qa.phaser.Order;
import org.jboss.qa.phaser.ParentId;
import org.jboss.qa.phaser.PhaseDefinition;
import org.jboss.qa.phaser.PhaseDefinitionProcessorBuilder;
import org.jboss.qa.phaser.util.ReflectionUtils;

public abstract class Phase<B extends PhaseDefinitionProcessorBuilder<A>, A extends Annotation> {
    private B phaseDefinitionBuilder = (PhaseDefinitionProcessorBuilder)ReflectionUtils.getGenericClass(this.getClass(), 0).newInstance();
    private Class<A> annotationClass = ReflectionUtils.getGenericClass(this.getClass(), 1);

    public List<PhaseDefinition<A>> findAllOrderedDefinitions(Class<?> jobClass) throws Exception {
        ArrayList<PhaseDefinition<A>> phaseDefinitions = new ArrayList<PhaseDefinition<A>>();
        A annotation = jobClass.getAnnotation(this.annotationClass);
        if (annotation != null) {
            phaseDefinitions.add(this.createPhaseDefinition(annotation, null));
        }
        for (Method m : jobClass.getMethods()) {
            annotation = m.getAnnotation(this.annotationClass);
            if (annotation == null) continue;
            phaseDefinitions.add(this.createPhaseDefinition(annotation, m));
        }
        Collections.sort(phaseDefinitions);
        return phaseDefinitions;
    }

    public PhaseDefinition<A> createPhaseDefinition(A annotation, Method method) {
        String id = (String)ReflectionUtils.invokeAnnotationMethod(annotation, Id.class);
        String parentId = (String)ReflectionUtils.invokeAnnotationMethod(annotation, ParentId.class);
        int order = (Integer)ReflectionUtils.invokeAnnotationMethod(annotation, Order.class);
        return new PhaseDefinition<A>(id == null || id.isEmpty() ? null : id, parentId == null || parentId.isEmpty() ? null : parentId, order, this, annotation, method);
    }

    public B getPhaseDefinitionBuilder() {
        return this.phaseDefinitionBuilder;
    }

    public Class<A> getAnnotationClass() {
        return this.annotationClass;
    }
}

