/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.phaser;

import java.lang.reflect.Method;
import org.jboss.qa.phaser.Id;
import org.jboss.qa.phaser.Order;
import org.jboss.qa.phaser.Phase;
import org.jboss.qa.phaser.PhaseValidationException;

public final class PhaseValidator {
    public static void validate(Phase phase) throws PhaseValidationException {
        PhaseValidator.validateIdPresence(phase);
        PhaseValidator.validateOrderType(phase);
    }

    private static void validateIdPresence(Phase phase) throws PhaseValidationException {
        for (Method m : phase.getAnnotationClass().getMethods()) {
            if (!m.isAnnotationPresent(Id.class)) continue;
            return;
        }
        throw new PhaseValidationException(Id.class.getName() + " annotation not present for any method of " + phase.getAnnotationClass().getCanonicalName());
    }

    private static void validateOrderType(Phase phase) throws PhaseValidationException {
        for (Method m : phase.getAnnotationClass().getMethods()) {
            if (!m.isAnnotationPresent(Order.class) || m.getReturnType().equals(Integer.TYPE)) continue;
            throw new PhaseValidationException(Order.class.getName() + " method does not return integer in " + phase.getAnnotationClass().getCanonicalName());
        }
    }

    private PhaseValidator() {
    }
}

