/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.wildfly;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.qa.jcontainer.Client;
import org.jboss.qa.jcontainer.wildfly.WildflyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.creaper.commands.foundation.online.CliFile;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.online.CliException;
import org.wildfly.extras.creaper.core.online.ManagementProtocol;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;

public class WildflyClient<T extends WildflyConfiguration>
extends Client<T> {
    private static final Logger log = LoggerFactory.getLogger(WildflyClient.class);
    protected ManagementProtocol protocol = ManagementProtocol.HTTP_REMOTING;
    protected OnlineManagementClient client;
    protected ModelNodeResult lastResult;

    public WildflyClient(T configuration) {
        super(configuration);
    }

    public boolean isConnected() {
        return this.client != null;
    }

    protected void connectInternal() throws Exception {
        this.client = ManagementClient.online((OnlineOptions)OnlineOptions.standalone().hostAndPort(((WildflyConfiguration)this.configuration).getHost(), ((WildflyConfiguration)this.configuration).getManagementPort()).protocol(this.protocol).build());
    }

    protected void executeInternal(String command) throws Exception {
        block2: {
            try {
                this.lastResult = this.client.execute(command);
            }
            catch (CliException e) {
                if (!e.getCause().getClass().isAssignableFrom(OperationFormatException.class)) break block2;
                this.client.executeCli(command);
            }
        }
    }

    protected void executeInternal(List<String> commands) throws Exception {
        for (String cmd : commands) {
            this.client.executeCli(cmd);
        }
    }

    public void execute(File file) throws Exception {
        log.info("Execute commands from file: {}", (Object)file.getAbsoluteFile());
        this.client.apply(new OnlineCommand[]{new CliFile(file)});
    }

    protected void closeInternal() throws IOException {
        this.client.close();
        this.client = null;
        this.lastResult = null;
    }

    public ModelNodeResult getCommandResult() {
        return this.lastResult;
    }

    public OnlineManagementClient getInternalClient() {
        return this.client;
    }
}

