/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.eap;

import org.jboss.qa.jcontainer.wildfly.WildflyConfiguration;

public class EapConfiguration
extends WildflyConfiguration {
    public static final int DEFAULT_MANAGEMENT_PORT = 9999;

    public EapConfiguration(Builder<?> builder) {
        super(builder);
    }

    public int getManagementPort() {
        return 9999 + this.portOffset;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends WildflyConfiguration.Builder<T> {
        public Builder() {
            this.xms = "1303m";
            this.xmx = "1303m";
            this.maxPermSize = "256m";
        }

        public EapConfiguration build() {
            super.build();
            StringBuilder javaOpts = new StringBuilder();
            String oldJavaOpts = (String)this.envProps.get("JAVA_OPTS");
            if (oldJavaOpts != null) {
                javaOpts.append(oldJavaOpts);
            }
            javaOpts.append(" -Djboss.modules.policy-permissions=true");
            this.envProps.put("JAVA_OPTS", javaOpts.toString());
            return new EapConfiguration(this);
        }
    }
}

