/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.profileservice.spi.virtual.assembly;

import java.io.IOException;

import org.jboss.profileservice.spi.virtual.VirtualArtifactMetaData;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.vfs.VirtualFile;

/**
 * A virtual deployment context.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 101822 $
 */
public interface VirtualDeploymentAssemblyContext
{

   /**
    * Get the root.
    * 
    * @return the root
    */
   VirtualFile getRoot();
   
   /**
    * Add a virtual artifact.
    * 
    * @param artifact the artifact
    * @throws IOException
    */
   void addArtifact(VirtualArtifactMetaData artifact) throws IOException;
   
   /**
    * Add a child deployment context.
    * 
    * @param child the virtual deployment child
    * @throws IOException
    */
   VirtualDeploymentAssemblyContext addChild(VirtualDeploymentMetaData child) throws IOException;

}

