/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.profileservice.spi.types;

import java.util.Arrays;

import org.jboss.metatype.api.types.EnumMetaType;

/**
 * An EnumMetaType for the kernel ControllerState values.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 100821 $
 */
// TODO we need to move this out of the SPI
public class ControllerStateMetaType extends EnumMetaType
{
   private static final long serialVersionUID = 2;
   private static final String[] VALID_VALUES = {
      "**ERROR**",
      "Not Installed",
      "PreInstall",
      "Described",
      "Instantiated",
      "Configured",
      "Create",
      "Start",
      "Installed"
   };
   public static final EnumMetaType TYPE = new ControllerStateMetaType();

   private ControllerStateMetaType()
   {
      super("org.jboss.dependency.spi.ControllerState", Arrays.asList(VALID_VALUES));
   }
}
