/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi.dependency;

import java.util.Collection;


/**
 * The ProfileService requirement resolver. 
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ProfileRequirementResolver
{

   /**
    * Get the unsatisfied requirements.
    * 
    * @return the  unsatisfied requirements
    */
   Collection<ProfileRequirement> getUnsatisfiedRequirements();
   
   /**
    * Add a requirement.
    * 
    * @param requirement the requirement.
    */
   void addRequirement(ProfileRequirement requirement);
   
   /**
    * Try to resolve the requirements.
    * 
    * @param requirements the requirements
    */
   boolean resolve();

   /**
    * Deploy the configuration.
    * 
    * @throws Exception
    */
   void deploy() throws Exception;
   
}

