/*
* JBoss, Home of Professional Open Source
* Copyright 2009, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi;

import java.io.IOException;
import java.util.Collection;

import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;

/**
 * The virtual deployment repository.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface VirtualDeploymentRepository
{
 
   /**
    * Get the associated repository ids.
    * 
    * @return the artifact repository ids.
    */
   Collection<ArtifactRepositoryId> getRepositoryIDs();
   
   /**
    * Resolve a artifact repository for a given {@code ArtifactId}. For the resolution
    * only the {@link ArtifactId#getType()} is taken into account.
    * 
    * @param <T> the type of the repository
    * @param artifactId the artifact id
    * @return the artifact repository, null if cannot be resolved
    */
   <T extends ArtifactId> ArtifactRepository<T> resolveArtifactRepository(T artifactId);
   
   /**
    * Create a profile deployment based on a virtual
    * deployment assembly descriptor.
    * 
    * @param virtual the virtual deployment meta data
    * @return the profile deployment
    * @throws IOException
    */
   ProfileDeployment createDeployment(VirtualDeploymentMetaData virtual) throws IOException;
   
}

