/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi.managed;

import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

/**
 * The managed profile. A wrapper around a installed profile, exposing additional 
 * information and operations which can be performed against a profile. A managed profile
 * is exposed through the {@code ActionController}, where actual operation have to be
 * performed inside a {@code ProfileModificationAction} to ensure consistent modifications.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ManagedProfile
{

   /**
    * Get the profile key.
    * 
    * @return the profile key
    */
   ProfileKey getProfileKey();
   
   /**
    * Get the profile.
    * 
    * @return the profile
    */
   Profile getProfile();
   
   /**
    * Get the profile meta data.
    * 
    * @return the profile meta data
    */
   ProfileMetaData getProfileMetaData();
   
   /**
    * Get the associated deploy plugin, handling
    * this profile.
    * 
    * @return the deployer
    */
   ManagedProfileDeployer getManagedDeployer();
   
   /**
    * Get the managed profile configuration.
    * 
    * @return the configuration
    */
   ManagedProfileConfiguration getConfiguration();
   
   /**
    * Get a managed deployment.
    * 
    * @param deployment the profile deployment
    * @return the managed deployment
    * @throws Exception
    */
   ManagedDeployment getManagedDeployment(ProfileDeployment deployment) throws Exception;
   
}

