/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.jboss.portal.cms.CMS;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.impl.interceptors.ACLInterceptor;
import org.jboss.portal.cms.impl.jcr.JCRCMS;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.workflow.CMSWorkflowUtil;
import org.jboss.portal.cms.workflow.Content;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class FinalizePublish
implements ActionHandler {
    private static Logger log = Logger.getLogger(FinalizePublish.class);

    public void execute(ExecutionContext executionContext) {
        Content content = this.readContent(executionContext);
        boolean approved = (Boolean)executionContext.getContextInstance().getVariable("approved");
        byte[] modifiedContent = (byte[])executionContext.getContextInstance().getVariable("modifiedContent");
        long processId = executionContext.getProcessInstance().getId();
        CMS cms = this.getCMSService();
        int lastIndex = content.getPath().lastIndexOf(47);
        String path = content.getPath().substring(0, lastIndex);
        String language = content.getPath().substring(lastIndex + 1);
        if (approved) {
            ACLInterceptor.turnOff();
            JCRCMS.turnOffWorkflow();
            Command command = cms.getCommandFactory().createContentGetVersionsCommand(content.getPath());
            List versions = (List)cms.execute(command);
            org.jboss.portal.cms.model.Content processContent = this.findProcessContent(processId, versions);
            if (processContent != null) {
                command = cms.getCommandFactory().createFileGetCommand(path, processContent.getVersionNumber(), new Locale(language));
                File file = (File)cms.execute(command);
                if (modifiedContent != null) {
                    file.getContent().setBytes(modifiedContent);
                }
                file.getContent().setApprovalProcessId(null);
                file.getContent().setWaitingForPublishApproval(false);
                command = cms.getCommandFactory().createUpdateFileCommand(file, file.getContent(), true);
                cms.execute(command);
            }
            JCRCMS.turnOnWorkflow();
            ACLInterceptor.turnOn();
        } else {
            ACLInterceptor.turnOff();
            JCRCMS.turnOffWorkflow();
            Command command = cms.getCommandFactory().createContentGetVersionsCommand(content.getPath());
            List versions = (List)cms.execute(command);
            List filtered = this.filterPending(versions);
            if (filtered == null || filtered.isEmpty()) {
                Command deleteCommand = cms.getCommandFactory().createDeleteCommand(path);
                cms.execute(deleteCommand);
            }
            JCRCMS.turnOnWorkflow();
            ACLInterceptor.turnOn();
        }
    }

    private org.jboss.portal.cms.model.Content findProcessContent(long processId, List versions) {
        org.jboss.portal.cms.model.Content content = null;
        if (versions != null) {
            for (int i = 0; i < versions.size(); ++i) {
                org.jboss.portal.cms.model.Content cour = (org.jboss.portal.cms.model.Content)versions.get(i);
                if (!cour.isWaitingForPublishApproval() || cour.getApprovalProcessId() == null || !cour.getApprovalProcessId().trim().equals(String.valueOf(processId))) continue;
                return cour;
            }
        }
        return content;
    }

    private List filterPending(List versions) {
        ArrayList<org.jboss.portal.cms.model.Content> filtered = new ArrayList<org.jboss.portal.cms.model.Content>();
        if (versions != null) {
            for (int i = 0; i < versions.size(); ++i) {
                org.jboss.portal.cms.model.Content content = (org.jboss.portal.cms.model.Content)versions.get(i);
                if (content.isWaitingForPublishApproval()) continue;
                filtered.add(content);
            }
        }
        return filtered;
    }

    private CMS getCMSService() {
        try {
            return CMSWorkflowUtil.getCMSService();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Content readContent(ExecutionContext executionContext) {
        try {
            Content content = null;
            Object object = executionContext.getContextInstance().getVariable("content");
            content = CMSWorkflowUtil.deserializeContent(object);
            return content;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

