/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.workflow;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.jboss.portal.cms.workflow.ApprovePublish;
import org.jboss.portal.cms.workflow.CMSWorkflowUtil;
import org.jboss.portal.cms.workflow.Content;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.identity.IdentityServiceController;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.workflow.WorkflowException;
import org.jboss.portal.workflow.service.WorkflowService;
import org.jbpm.JbpmContext;
import org.jbpm.db.GraphSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApprovePublishImpl
extends AbstractJBossService
implements ApprovePublish {
    private static final Logger log = Logger.getLogger(ApprovePublishImpl.class);
    private WorkflowService workflowService = null;
    private IdentityServiceController identityServiceController = null;
    private String process = null;
    private String processName = null;
    private String managerRoles = null;
    private String[] managers = null;
    private Set<String> managerSet = null;
    private boolean overwrite = false;
    private String from = null;
    private String subject = null;
    private String body = null;
    private JNDI.Binding jndiBinding;
    private MembershipModule membershipModule = null;
    private UserModule userModule = null;
    private String jndiName = null;

    public void startService() throws Exception {
        super.startService();
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
        ByteArrayInputStream is = null;
        JbpmContext jbpmContext = null;
        try {
            is = new ByteArrayInputStream(this.process.getBytes());
            jbpmContext = this.workflowService.getJbpmConfiguration().createJbpmContext();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            Element root = document.getDocumentElement();
            this.processName = root.getAttribute("name");
            ProcessDefinition processDefinition = jbpmContext.getGraphSession().findLatestProcessDefinition(this.processName);
            if (processDefinition == null) {
                processDefinition = ProcessDefinition.parseXmlString((String)this.process);
                jbpmContext.deployProcessDefinition(processDefinition);
            } else {
                ProcessDefinition fromConfig = ProcessDefinition.parseXmlString((String)this.process);
                if (this.overwrite) {
                    jbpmContext.deployProcessDefinition(fromConfig);
                }
            }
        }
        catch (Exception e) {
            try {
                this.stopService();
                throw e;
            }
            catch (Throwable throwable) {
                IOTools.safeClose(is);
                IOTools.safeClose(jbpmContext);
                throw throwable;
            }
        }
        IOTools.safeClose((Closeable)is);
        IOTools.safeClose((Object)jbpmContext);
        StringTokenizer st = new StringTokenizer(this.managerRoles, ",");
        this.managers = new String[st.countTokens()];
        this.managerSet = new HashSet<String>();
        for (int i = 0; i < this.managers.length; ++i) {
            this.managers[i] = st.nextToken().trim();
            this.managerSet.add(this.managers[i]);
        }
        this.membershipModule = (MembershipModule)this.identityServiceController.getIdentityContext().getObject("Membership");
        this.userModule = (UserModule)this.identityServiceController.getIdentityContext().getObject("User");
    }

    public void stopService() throws Exception {
        super.stopService();
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public String getProcess() {
        return this.process;
    }

    public void setProcess(String process) {
        this.process = process;
    }

    public String getManagerRoles() {
        return this.managerRoles;
    }

    public void setManagerRoles(String managerRoles) {
        this.managerRoles = managerRoles;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public IdentityServiceController getIdentityServiceController() {
        return this.identityServiceController;
    }

    public void setIdentityServiceController(IdentityServiceController identityServiceController) {
        this.identityServiceController = identityServiceController;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long requestApproval(Content content) throws WorkflowException {
        JbpmContext jbpmContext;
        long processId;
        block5: {
            processId = 0L;
            jbpmContext = null;
            ProcessInstance processInstance = null;
            boolean success = false;
            try {
                jbpmContext = this.workflowService.getJbpmConfiguration().createJbpmContext();
                processInstance = jbpmContext.newProcessInstance(this.processName);
                Token token = processInstance.getRootToken();
                processInstance.getContextInstance().setVariable("content", (Object)content);
                processInstance.getContextInstance().setVariable("managers", (Object)this.managers);
                processInstance.getContextInstance().setVariable("from", (Object)this.from);
                processInstance.getContextInstance().setVariable("subject", (Object)this.subject);
                processInstance.getContextInstance().setVariable("body", (Object)this.body);
                token.signal();
                success = true;
                if (processInstance == null || !success) break block5;
            }
            catch (Exception e) {
                try {
                    success = false;
                    throw new WorkflowException(e);
                }
                catch (Throwable throwable) {
                    if (processInstance != null && success) {
                        jbpmContext.save(processInstance);
                        processId = processInstance.getId();
                    }
                    IOTools.safeClose((Object)jbpmContext);
                    throw throwable;
                }
            }
            jbpmContext.save(processInstance);
            processId = processInstance.getId();
        }
        IOTools.safeClose((Object)jbpmContext);
        return processId;
    }

    @Override
    public void processManagerResponse(long processId, String manager, boolean approved) throws WorkflowException {
        boolean isManager;
        JbpmContext jbpmContext;
        block14: {
            ProcessInstance processInstance;
            block12: {
                block13: {
                    jbpmContext = null;
                    processInstance = null;
                    isManager = false;
                    jbpmContext = this.workflowService.getJbpmConfiguration().createJbpmContext();
                    processInstance = jbpmContext.loadProcessInstance(processId);
                    if (!processInstance.hasEnded()) break block12;
                    log.debug((Object)"This process has already ended...");
                    if (processInstance == null) break block13;
                    jbpmContext.save(processInstance);
                }
                if (!isManager) {
                    WorkflowException we = new WorkflowException("You are not authorized to Approve/Deny content publish requests");
                    throw we;
                }
                IOTools.safeClose((Object)jbpmContext);
                return;
            }
            try {
                processInstance.getContextInstance().setVariable("approved", (Object)new Boolean(approved));
                Collection allTasks = processInstance.getTaskMgmtInstance().getTaskInstances();
                if (allTasks != null) {
                    for (TaskInstance cour : allTasks) {
                        if (!this.isManager(manager, cour.getActorId())) continue;
                        isManager = true;
                        log.debug((Object)("Manager=" + cour.getActorId() + "(" + processId + ")"));
                        if (cour.getVariable(processInstance.getId() + ":" + cour.getId()) != null) continue;
                        if (!approved) {
                            cour.start();
                            cour.end("rejection");
                            break;
                        }
                        cour.start();
                        cour.end("approval");
                        break;
                    }
                }
                if (processInstance == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw new WorkflowException(e);
                }
                catch (Throwable throwable) {
                    if (processInstance != null) {
                        jbpmContext.save(processInstance);
                    }
                    if (!isManager) {
                        WorkflowException we = new WorkflowException("You are not authorized to Approve/Deny content publish requests");
                        throw we;
                    }
                    IOTools.safeClose((Object)jbpmContext);
                    throw throwable;
                }
            }
            jbpmContext.save(processInstance);
        }
        if (!isManager) {
            WorkflowException we = new WorkflowException("You are not authorized to Approve/Deny content publish requests");
            throw we;
        }
        IOTools.safeClose((Object)jbpmContext);
    }

    @Override
    public void processManagerResponse(long processId, String manager, String modifiedContent) throws WorkflowException {
        boolean isManager;
        JbpmContext jbpmContext;
        block13: {
            ProcessInstance processInstance;
            block11: {
                block12: {
                    jbpmContext = null;
                    processInstance = null;
                    isManager = false;
                    jbpmContext = this.workflowService.getJbpmConfiguration().createJbpmContext();
                    processInstance = jbpmContext.loadProcessInstance(processId);
                    if (!processInstance.hasEnded()) break block11;
                    log.debug((Object)"This process has already ended...");
                    if (processInstance == null) break block12;
                    jbpmContext.save(processInstance);
                }
                if (!isManager) {
                    throw new WorkflowException("You are not authorized to Approve/Deny content publish requests");
                }
                IOTools.safeClose((Object)jbpmContext);
                return;
            }
            try {
                processInstance.getContextInstance().setVariable("approved", (Object)new Boolean(true));
                processInstance.getContextInstance().setVariable("modifiedContent", (Object)modifiedContent.getBytes());
                Collection allTasks = processInstance.getTaskMgmtInstance().getTaskInstances();
                if (allTasks != null) {
                    for (TaskInstance currentTask : allTasks) {
                        if (!this.isManager(manager, currentTask.getActorId())) continue;
                        isManager = true;
                        log.debug((Object)("Manager=" + currentTask.getActorId() + "(" + processId + ")"));
                        if (currentTask.getVariable(processInstance.getId() + ":" + currentTask.getId()) != null) continue;
                        currentTask.start();
                        currentTask.end("approval");
                        break;
                    }
                }
                if (processInstance == null) break block13;
            }
            catch (Exception e) {
                try {
                    throw new WorkflowException(e);
                }
                catch (Throwable throwable) {
                    if (processInstance != null) {
                        jbpmContext.save(processInstance);
                    }
                    if (!isManager) {
                        throw new WorkflowException("You are not authorized to Approve/Deny content publish requests");
                    }
                    IOTools.safeClose((Object)jbpmContext);
                    throw throwable;
                }
            }
            jbpmContext.save(processInstance);
        }
        if (!isManager) {
            throw new WorkflowException("You are not authorized to Approve/Deny content publish requests");
        }
        IOTools.safeClose((Object)jbpmContext);
    }

    @Override
    public Collection<Content> getPendingQueue(String filePath) throws WorkflowException {
        ArrayList<Content> pendingQueue = new ArrayList<Content>();
        JbpmContext jbpmContext = null;
        try {
            jbpmContext = this.workflowService.getJbpmConfiguration().createJbpmContext();
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessDefinition processDef = graphSession.findLatestProcessDefinition(this.processName);
            List processInstances = graphSession.findProcessInstances(processDef.getId());
            if (processInstances != null) {
                for (ProcessInstance processInstance : processInstances) {
                    Content content;
                    if (processInstance.hasEnded() || (content = this.getContent(processInstance)) == null) continue;
                    int lastIndex = content.getPath().lastIndexOf(47);
                    String criteriaPath = content.getPath().substring(0, lastIndex);
                    if (!criteriaPath.trim().equals(filePath.trim())) continue;
                    content.setProcessId(String.valueOf(processInstance.getId()));
                    pendingQueue.add(content);
                }
            }
        }
        catch (Exception e) {
            try {
                log.error((Object)this, (Throwable)e);
                throw new WorkflowException(e);
            }
            catch (Throwable throwable) {
                IOTools.safeClose(jbpmContext);
                throw throwable;
            }
        }
        IOTools.safeClose((Object)jbpmContext);
        return pendingQueue;
    }

    @Override
    public Collection<Content> getAllPendingInQueue() throws WorkflowException {
        ArrayList<Content> pendingQueue = new ArrayList<Content>();
        JbpmContext jbpmContext = null;
        try {
            jbpmContext = this.workflowService.getJbpmConfiguration().createJbpmContext();
            GraphSession graphSession = jbpmContext.getGraphSession();
            ProcessDefinition processDef = graphSession.findLatestProcessDefinition(this.processName);
            List processInstances = graphSession.findProcessInstances(processDef.getId());
            if (processInstances != null) {
                for (ProcessInstance processInstance : processInstances) {
                    Content content;
                    if (processInstance.hasEnded() || (content = this.getContent(processInstance)) == null) continue;
                    content.setProcessId(String.valueOf(processInstance.getId()));
                    pendingQueue.add(content);
                }
            }
        }
        catch (Exception e) {
            try {
                log.error((Object)this, (Throwable)e);
                throw new WorkflowException(e);
            }
            catch (Throwable throwable) {
                IOTools.safeClose(jbpmContext);
                throw throwable;
            }
        }
        IOTools.safeClose((Object)jbpmContext);
        return pendingQueue;
    }

    @Override
    public Set<String> getManagers() {
        return this.managerSet;
    }

    private boolean isManager(String user, String managerRole) throws Exception {
        boolean isManager = false;
        Set userRoles = this.membershipModule.getRoles(this.userModule.findUserByUserName(user));
        if (userRoles != null) {
            for (Role cour : userRoles) {
                if (!cour.getName().equalsIgnoreCase(managerRole)) continue;
                isManager = true;
                break;
            }
        }
        return isManager;
    }

    private Content getContent(ProcessInstance processInstance) throws Exception {
        Content content = null;
        Object object = processInstance.getContextInstance().getVariable("content");
        content = CMSWorkflowUtil.deserializeContent(object);
        return content;
    }
}

