/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.util;

import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;

public class NodeUtil {
    public static final String PATH_SEPARATOR = "/";
    public static final Pattern CHECK_FOR_XSS_PATTERN = Pattern.compile("[^<>\\(\\)=]*");

    public static String getParentPath(String sPath) throws Exception {
        String parentPath = "";
        if (!NodeUtil.isValidPath(sPath)) {
            throw new Exception("Not a valid basePath " + sPath);
        }
        String[] pathChunks = sPath.split(PATH_SEPARATOR);
        if (pathChunks.length == 2) {
            return PATH_SEPARATOR;
        }
        for (int i = 0; i < pathChunks.length - 1; ++i) {
            if (pathChunks[i].equals("")) continue;
            parentPath = parentPath + PATH_SEPARATOR + pathChunks[i];
        }
        return parentPath;
    }

    public static String getNodeName(String path) throws Exception {
        String[] pathChunks = path.split(PATH_SEPARATOR);
        if (!NodeUtil.isValidPath(path)) {
            throw new Exception("Not a valid basePath!");
        }
        return pathChunks[pathChunks.length - 1];
    }

    public static boolean isValidPath(String sPath) {
        return sPath != null && !sPath.equals(PATH_SEPARATOR) && !sPath.endsWith(PATH_SEPARATOR) && sPath.startsWith(PATH_SEPARATOR) && !sPath.equals("") && CHECK_FOR_XSS_PATTERN.matcher(sPath).matches();
    }

    public static void print(Node node) {
        try {
            System.out.println("################### NAME: " + node.getName() + " ###################");
            System.out.println("################### PATH: " + node.getPath() + " ###################");
            PropertyIterator pi = node.getProperties();
            while (pi.hasNext()) {
                Property p = pi.nextProperty();
                if (p.getName().equals("jcr:mixinTypes") || p.getName().equals("jcr:predecessors")) continue;
                System.out.println(p.getName() + " = " + p.getString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

