/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.security;

import java.io.InputStream;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.portal.cms.impl.jcr.JCRCMS;
import org.jboss.portal.cms.security.AuthorizationProvider;
import org.jboss.portal.cms.security.Criteria;
import org.jboss.portal.cms.security.PermRoleAssoc;
import org.jboss.portal.cms.security.PermUserAssoc;
import org.jboss.portal.cms.security.Permission;
import org.jboss.portal.cms.util.HibernateUtil;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.identity.AnonymousRole;
import org.jboss.portal.identity.IdentityConfiguration;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.IdentityServiceController;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.db.HibernateUserModuleImpl;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.jems.hibernate.HibernateProvider;
import org.jboss.portal.security.impl.jacc.JACCPortalPrincipal;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.security.spi.provider.PermissionFactory;
import org.jboss.portal.security.spi.provider.PermissionRepository;
import org.jboss.portal.security.spi.provider.SecurityConfigurationException;

public class AuthorizationProviderImpl
extends AbstractJBossService
implements AuthorizationProvider {
    private IdentityServiceController identityServiceController = null;
    private MembershipModule membershipModule = null;
    private UserModule userModule = null;
    private String cmsRootUserName = null;
    private User adminUser = null;
    private String cmsSessionFactory = null;
    private String schemaName = null;
    private String nativePermissionQuery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startService() throws Exception {
        super.startService();
        this.membershipModule = (MembershipModule)this.identityServiceController.getIdentityContext().getObject("Membership");
        this.userModule = (UserModule)this.identityServiceController.getIdentityContext().getObject("User");
        try {
            HibernateProvider hibernateProvider = (HibernateProvider)MBeanProxy.get(HibernateProvider.class, (ObjectName)new ObjectName("portal:service=Hibernate,type=Instance"), (MBeanServer)this.getServer());
            if (hibernateProvider != null) {
                this.schemaName = hibernateProvider.getConfig().getProperty("hibernate.default_schema");
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Can't access \"portal:service=Hibernate,type=Instance\" MBean");
        }
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("findPermissionsByUser.sql");
            byte[] bytes = IOTools.getBytes((InputStream)is);
            String nativeSql = new String(bytes).trim();
            String schemaPrefix = this.schemaName != null ? this.schemaName + "." : "";
            this.nativePermissionQuery = MessageFormat.format(nativeSql, schemaPrefix);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public DomainConfigurator getConfigurator() {
        return this;
    }

    public PermissionFactory getPermissionFactory() {
        return null;
    }

    public PermissionRepository getPermissionRepository() {
        return null;
    }

    public String getType() {
        return this.getClass().getName();
    }

    public String getCmsRootUserName() {
        return this.cmsRootUserName;
    }

    public void setCmsRootUserName(String cmsRootUserName) {
        this.cmsRootUserName = cmsRootUserName;
    }

    public String getCmsSessionFactory() {
        return this.cmsSessionFactory;
    }

    public void setCmsSessionFactory(String cmsSessionFactory) {
        this.cmsSessionFactory = cmsSessionFactory;
    }

    public void setSecurityBindings(String uri, Set securityBindings) throws SecurityConfigurationException {
        if (securityBindings != null) {
            for (Permission securityBinding : securityBindings) {
                if (securityBinding.getRoles() != null || securityBinding.getUsers() != null) {
                    this.store(securityBinding, securityBinding.getRoles(), securityBinding.getUsers());
                    continue;
                }
                this.store(securityBinding);
            }
        }
    }

    public void removeSecurityBindings(String uri) throws SecurityConfigurationException {
        Set permissions = this.getSecurityBindings(uri);
        this.remove(permissions);
    }

    public Set getSecurityBindings(String uri) {
        String value;
        int index;
        String criteria;
        String name;
        Criteria input;
        Collection cour;
        HashSet permissions = new HashSet();
        if (uri.startsWith("user://")) {
            String userId = uri.substring("user://".length());
            Collection cour2 = this.findPermissionsByUser(userId);
            if (cour2 != null) {
                permissions.addAll(cour2);
            }
        } else if (uri.startsWith("role://")) {
            String roleId = uri.substring("role://".length());
            Collection cour3 = this.findPermissionsByRole(roleId);
            if (cour3 != null) {
                permissions.addAll(cour3);
            }
        } else if (uri.startsWith("criteria://") && (cour = this.findPermissionsByCriteria(input = new Criteria(name = (criteria = uri.substring("criteria://".length())).substring(0, index = criteria.indexOf(47)), value = criteria.substring(index + 1)))) != null) {
            permissions.addAll(cour);
        }
        return permissions;
    }

    public User getRoot() {
        if (this.adminUser == null) {
            Session session = HibernateUtil.getSessionFactory(this.cmsSessionFactory).getCurrentSession();
            Transaction tx = session.beginTransaction();
            try {
                this.adminUser = this.userModule.findUserByUserName(this.cmsRootUserName);
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw new RuntimeException(e);
            }
        }
        return this.adminUser;
    }

    public String getDefaultAdminRole() {
        try {
            String defaultAdminRole = null;
            IdentityConfiguration configuration = (IdentityConfiguration)this.identityServiceController.getIdentityContext().getObject("IdentityConfiguration");
            defaultAdminRole = configuration.getValue("defaultAdminRole");
            return defaultAdminRole;
        }
        catch (IdentityException ie) {
            throw new RuntimeException(ie);
        }
    }

    public String getUserURI(String userId) {
        return "user://" + userId;
    }

    public String getRoleURI(String roleId) {
        return "role://" + roleId;
    }

    public String getCriteriaURI(String name, String value) {
        return "criteria://" + name + "/" + value;
    }

    public MembershipModule getMembershipModule() {
        return this.membershipModule;
    }

    public IdentityServiceController getIdentityServiceController() {
        return this.identityServiceController;
    }

    public void setIdentityServiceController(IdentityServiceController identityServiceController) {
        this.identityServiceController = identityServiceController;
    }

    private void store(Permission permission, Collection roles, Collection users) {
        Object cour;
        if (roles != null) {
            HashSet<Object> roleAssoc = new HashSet<Object>();
            for (Role role : roles) {
                cour = new PermRoleAssoc();
                if (!(role instanceof AnonymousRole)) {
                    ((PermRoleAssoc)cour).setRoleId(role.getName());
                } else {
                    ((PermRoleAssoc)cour).setRoleId("Anonymous");
                }
                roleAssoc.add(cour);
            }
            permission.setRoleAssoc(roleAssoc);
        } else {
            permission.setRoleAssoc(null);
        }
        if (users != null) {
            HashSet<Object> userAssoc = new HashSet<Object>();
            for (User user : users) {
                cour = new PermUserAssoc();
                ((PermUserAssoc)cour).setUserId(user.getUserName());
                userAssoc.add(cour);
            }
            permission.setUserAssoc(userAssoc);
        } else {
            permission.setUserAssoc(null);
        }
        this.store(permission);
    }

    private void store(Permission permission) {
        Session session = HibernateUtil.getSessionFactory(this.cmsSessionFactory).getCurrentSession();
        session.saveOrUpdate((Object)permission);
    }

    private void remove(Collection permissions) {
        Session session = HibernateUtil.getSessionFactory(this.cmsSessionFactory).getCurrentSession();
        if (permissions != null) {
            for (Permission permission : permissions) {
                session.delete((Object)permission);
            }
        }
    }

    private Collection findPermissionsByUser(String userId) {
        Session session = HibernateUtil.getSessionFactory(this.cmsSessionFactory).getCurrentSession();
        try {
            HashSet permissions = new HashSet();
            String lookupByUser = "SELECT permission from Permission permission JOIN permission.userAssoc user WHERE user.userId=?";
            Query userQuery = session.createQuery(lookupByUser);
            userQuery.setString(0, userId);
            userQuery.setCacheable(true);
            permissions.addAll(userQuery.list());
            if (this.userModule instanceof HibernateUserModuleImpl) {
                SQLQuery roleQuery = session.createSQLQuery(this.nativePermissionQuery).addEntity(Permission.class);
                roleQuery.setString(0, userId);
                roleQuery.setCacheable(true);
                permissions.addAll(roleQuery.list());
            } else {
                Set belongedRoles = this.getCurrentRoles();
                if (belongedRoles != null) {
                    for (String role : belongedRoles) {
                        Collection rolePermissions = this.findPermissionsByRole(role);
                        if (rolePermissions == null || rolePermissions.isEmpty()) continue;
                        permissions.addAll(rolePermissions);
                    }
                }
            }
            return permissions;
        }
        catch (Exception e) {
            this.log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Collection findPermissionsByRole(String roleId) {
        HashSet permissions = new HashSet();
        String lookupByRole = "SELECT permission from Permission permission JOIN permission.roleAssoc role WHERE role.roleId=?";
        Session session = HibernateUtil.getSessionFactory(this.cmsSessionFactory).getCurrentSession();
        try {
            Query roleQuery = session.createQuery(lookupByRole);
            roleQuery.setString(0, roleId);
            roleQuery.setCacheable(true);
            permissions.addAll(roleQuery.list());
        }
        catch (Exception e) {
            this.log.error((Object)this, (Throwable)e);
            throw new RuntimeException(e);
        }
        return permissions;
    }

    private Collection findPermissionsByCriteria(Criteria criteria) {
        HashSet permissions = new HashSet();
        String lookupByCriteria = "SELECT permission from Permission permission JOIN permission.criteria criteria WHERE criteria.name=? AND criteria.value=?";
        Session session = HibernateUtil.getSessionFactory(this.cmsSessionFactory).getCurrentSession();
        try {
            Query criteriaQuery = session.createQuery(lookupByCriteria);
            criteriaQuery.setString(0, criteria.getName());
            criteriaQuery.setString(1, criteria.getValue());
            criteriaQuery.setCacheable(true);
            permissions.addAll(criteriaQuery.list());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return permissions;
    }

    private Set getCurrentRoles() throws PolicyContextException {
        Set<Object> roles = new HashSet();
        Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
        if (subject != null) {
            Set<JACCPortalPrincipal> tmp = subject.getPrincipals(JACCPortalPrincipal.class);
            JACCPortalPrincipal pp2 = null;
            for (JACCPortalPrincipal pp2 : tmp) {
                if (pp2 != null) break;
            }
            if (pp2 == null) {
                pp2 = new JACCPortalPrincipal(subject);
                tmp.add(pp2);
                for (Principal role : pp2.getRoles()) {
                    roles.add(role.getName());
                }
            }
        }
        if (roles.isEmpty()) {
            roles = JCRCMS.getRoles();
        }
        return roles;
    }
}

