/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.search;

import java.util.List;
import org.jboss.portal.cms.CMS;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.search.CMSResult;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.search.FederatedSearcher;
import org.jboss.portal.search.Query;
import org.jboss.portal.search.QueryConverter;
import org.jboss.portal.search.impl.AbstractFederatedSearcher;
import org.jboss.portal.search.impl.jcr.JCRQuery;
import org.jboss.portal.search.impl.jcr.JCRQueryConverter;
import org.jboss.portal.search.result.Result;
import org.jboss.portal.search.result.ResultSet;

public class CMSFederatedSearch
extends AbstractFederatedSearcher {
    private CMS cms;
    private String urlPrefix;
    private JCRQueryConverter queryConverter;

    public CMSFederatedSearch(String id) {
        this.setId(id);
        this.setDisplayName(new LocalizedString("Content Management System"));
        this.urlPrefix = "portal/content";
        this.queryConverter = new JCRQueryConverter();
    }

    public void setCMS(CMS cms) {
        this.cms = cms;
    }

    public ResultSet search(Query query) {
        Command searchCommand = this.cms.getCommandFactory().createSearchCommand((JCRQuery)query);
        List files = (List)this.cms.execute(searchCommand);
        ResultSet results = new ResultSet((FederatedSearcher)this);
        for (File file : files) {
            results.add((Result)new CMSResult(file, this.urlPrefix));
        }
        return results;
    }

    public QueryConverter getQueryConverter() {
        return this.queryConverter;
    }
}

