/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.util;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.FolderImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.impl.jcr.util.NodeTypeUtil;
import org.jboss.portal.cms.util.NodeUtil;

public class ResourceUtil {
    public static void createParentHierarchy(JCRCommandContext context, String parentPath) throws CMSException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(parentPath, "/");
            StringBuffer buffer = new StringBuffer("/");
            while (tokenizer.hasMoreTokens()) {
                buffer.append(tokenizer.nextToken());
                String cour = buffer.toString();
                JCRCommand nodeExists = (JCRCommand)context.getCommandFactory().createItemExistsCommand(cour);
                Boolean bExists = (Boolean)context.execute(nodeExists);
                if (!bExists.booleanValue()) {
                    ResourceUtil.createFolder(context, cour);
                } else {
                    Node node = (Node)context.getSession().getItem(cour);
                    if (NodeTypeUtil.isFile(node)) {
                        throw new CMSException("Invalid Path: " + parentPath + " : Trying to create a Folder inside a File");
                    }
                }
                if (!tokenizer.hasMoreTokens()) continue;
                buffer.append("/");
            }
        }
        catch (Exception e) {
            throw new CMSException(e);
        }
    }

    private static void createFolder(JCRCommandContext context, String folderPath) throws CMSException {
        try {
            FolderImpl folder = new FolderImpl();
            folder.setName(folderPath);
            folder.setDescription(folderPath);
            folder.setTitle(folderPath);
            folder.setLastModified(new Date());
            folder.setBasePath(folderPath);
            String parentPath = NodeUtil.getParentPath(folder.getBasePath());
            String nodeName = NodeUtil.getNodeName(folder.getBasePath());
            Node parentNode = (Node)context.getSession().getItem(parentPath);
            Node folderNode = parentNode.addNode(nodeName, "portalcms:folder");
            folderNode.setProperty("portalcms:description", (Value)new StringValue(folder.getDescription()));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(folder.getLastModified());
            DateValue dv = new DateValue(calendar);
            parentNode.setProperty("portalcms:lastmodified", (Value)dv);
            folderNode.setProperty("portalcms:lastmodified", (Value)dv);
            parentNode.save();
        }
        catch (Exception e) {
            throw new CMSException(e);
        }
    }
}

