/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.jackrabbit;

import java.io.StringReader;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.jboss.logging.Logger;
import org.jboss.portal.cms.impl.jcr.JCRService;
import org.jboss.portal.cms.util.RepositoryUtil;
import org.xml.sax.InputSource;

public class JackrabbitJCRService
implements JCRService {
    private static final Logger log = Logger.getLogger(JackrabbitJCRService.class);
    private RepositoryImpl repository;
    private String homeDir;
    private String repositoryName;
    private String config;

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public void start() throws Exception {
        log.debug((Object)("JackRabbit configuration: " + this.config));
        StringReader reader = new StringReader(this.config);
        InputSource src = new InputSource(reader);
        RepositoryConfig cfg = RepositoryConfig.create((InputSource)src, (String)this.homeDir);
        this.repository = RepositoryImpl.create((RepositoryConfig)cfg);
        log.info((Object)("Repository '" + this.repositoryName + "' created"));
        if (!this.nodeTypesExist()) {
            log.info((Object)"The repository does not know about CMS node types");
            this.registerCustomNodeTypes((Repository)this.repository);
        } else {
            log.info((Object)"The repository has already the CMS node types registered");
        }
    }

    public void stop() {
        try {
            log.info((Object)"Shutting down repository");
            this.repository.shutdown();
            log.info((Object)"Repository shut down successfully");
        }
        catch (Exception e) {
            log.error((Object)"Failed to unregister repository. Some locks may persist!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeTypesExist() throws Exception {
        boolean bl;
        Session session = null;
        try {
            session = RepositoryUtil.login((Repository)this.repository, "anonid", "");
            Workspace wosp = session.getWorkspace();
            NodeTypeManager ntMgr = wosp.getNodeTypeManager();
            NodeTypeRegistry ntReg = ((NodeTypeManagerImpl)ntMgr).getNodeTypeRegistry();
            boolean folderType = ntReg.isRegistered(NameFactoryImpl.getInstance().create("http://jboss.org/jcr/portalcms", "folder"));
            boolean fileType = ntReg.isRegistered(NameFactoryImpl.getInstance().create("http://jboss.org/jcr/portalcms", "file"));
            boolean content = ntReg.isRegistered(NameFactoryImpl.getInstance().create("http://jboss.org/jcr/portalcms", "content"));
            session.logout();
            bl = folderType && fileType && content;
        }
        catch (Throwable throwable) {
            RepositoryUtil.safeLogout(session);
            throw throwable;
        }
        RepositoryUtil.safeLogout(session);
        return bl;
    }

    public Session login(String user, String password) throws Exception {
        return RepositoryUtil.login((Repository)this.repository, user, password);
    }

    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCustomNodeTypes(Repository repository) throws Exception {
        Session session = null;
        try {
            log.info((Object)"Creating CMS nodeTypes.");
            session = RepositoryUtil.login(repository, "anonid", "");
            Workspace wsp = session.getWorkspace();
            NamespaceRegistry registry = wsp.getNamespaceRegistry();
            registry.registerNamespace("portalcms", "http://jboss.org/jcr/portalcms");
            this.registerNodeType(session, NameFactoryImpl.getInstance().create("http://jboss.org/jcr/portalcms", "folder"), true, "hierarchyNode");
            this.registerNodeType(session, NameFactoryImpl.getInstance().create("http://jboss.org/jcr/portalcms", "file"), false, "hierarchyNode");
            this.registerNodeType(session, NameFactoryImpl.getInstance().create("http://jboss.org/jcr/portalcms", "content"), false, "hierarchyNode");
            log.info((Object)"Custom CMS nodeTypes registered.");
        }
        catch (Throwable throwable) {
            RepositoryUtil.safeLogout(session);
            throw throwable;
        }
        RepositoryUtil.safeLogout(session);
    }

    private void registerNodeType(Session session, Name qname, boolean sameNameChild, String superType) throws RepositoryException, InvalidNodeTypeDefException {
        NodeTypeDef ntd = new NodeTypeDef();
        ntd.setName(qname);
        ntd.setOrderableChildNodes(false);
        PropDefImpl propDef = new PropDefImpl();
        propDef.setDeclaringNodeType(ntd.getName());
        ntd.setSupertypes(new Name[]{NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/nt/1.0", superType)});
        ntd.setPropertyDefs(new PropDef[]{propDef});
        NodeDefImpl def = this.getChildNodeDef(ntd.getName(), superType);
        ntd.setChildNodeDefs(new NodeDef[]{def});
        Workspace wosp = session.getWorkspace();
        NodeTypeManager ntMgr = wosp.getNodeTypeManager();
        NodeTypeRegistry ntReg = ((NodeTypeManagerImpl)ntMgr).getNodeTypeRegistry();
        ntReg.registerNodeType(ntd);
    }

    private NodeDefImpl getChildNodeDef(Name declaringNodeType, String superType) {
        NodeDefImpl nodeDef = new NodeDefImpl();
        nodeDef.setName(NameFactoryImpl.getInstance().create("", "*"));
        nodeDef.setAutoCreated(false);
        nodeDef.setMandatory(false);
        nodeDef.setProtected(false);
        nodeDef.setOnParentVersion(2);
        nodeDef.setAllowsSameNameSiblings(true);
        nodeDef.setRequiredPrimaryTypes(new Name[]{NameFactoryImpl.getInstance().create("http://www.jcp.org/jcr/nt/1.0", superType)});
        nodeDef.setDeclaringNodeType(declaringNodeType);
        return nodeDef;
    }
}

