/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.jackrabbit;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jgroups.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredCacheListener
implements TreeCacheListener {
    private static Logger log = LoggerFactory.getLogger(ClusteredCacheListener.class);
    private static Map internalCaches = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private static Map nodeToItem = Collections.synchronizedMap(new ReferenceMap(0, 2));
    private static int cacheKeyCounter = 0;
    private TreeCache treeCache = null;

    public static void storeInternalCache(String node, ItemId item, ItemStateCache cache) {
        if (!internalCaches.containsValue(cache)) {
            internalCaches.put(ClusteredCacheListener.getCacheKey(), cache);
        }
        nodeToItem.put(node, item);
    }

    private static synchronized String getCacheKey() {
        return String.valueOf(cacheKeyCounter++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeEvicted(Fqn fqn) {
        block12: {
            try {
                String nodeName = fqn.toString();
                ItemId item = (ItemId)nodeToItem.get(nodeName);
                if (item == null) break block12;
                ItemId itemId = item;
                synchronized (itemId) {
                    if (!nodeToItem.containsKey(nodeName)) {
                        return;
                    }
                    nodeToItem.remove(nodeName);
                    Object[] values = internalCaches.values().toArray();
                    for (int i = 0; i < values.length; ++i) {
                        ItemStateCache internalCache;
                        ItemStateCache itemStateCache = internalCache = (ItemStateCache)values[i];
                        synchronized (itemStateCache) {
                            if (internalCache.isCached(item)) {
                                ItemState state = internalCache.retrieve(item);
                                log.debug("Evicting..." + item.toString() + " (Transient:" + state.isTransient() + ")");
                                if (state.getStatus() == 1) {
                                    state.discard();
                                }
                            }
                            continue;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void nodeModified(Fqn fqn) {
    }

    public void nodeCreated(Fqn fqn) {
    }

    public void nodeRemoved(Fqn fqn) {
    }

    public void nodeLoaded(Fqn fqn) {
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache treeCache) {
        this.treeCache = treeCache;
    }

    public void cacheStopped(TreeCache treeCache) {
    }

    public void viewChange(View view) {
    }

    public static String parseNodeName(String id) {
        String node = null;
        node = id.replace('/', '_');
        node = node.replace(':', '_');
        node = node.replace('{', '_');
        node = node.replace('}', '_');
        return node;
    }
}

