/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.search.impl.jcr.JCRQuery;

public class SearchCommand
extends JCRCommand {
    private static final long serialVersionUID = 2614067614144410297L;
    private JCRQuery query;

    public SearchCommand(JCRQuery query) {
        this.query = query;
    }

    public Object execute() throws CMSException {
        Session session = this.context.getSession();
        Workspace workspace = session.getWorkspace();
        ArrayList<FileImpl> files = new ArrayList<FileImpl>();
        String queryString = null;
        try {
            QueryManager queryManager = workspace.getQueryManager();
            queryString = this.query.getJcrQuery();
            if (!"".equals(queryString) && this.query != null) {
                Query jcrQuery = queryManager.createQuery(queryString, "xpath");
                QueryResult queryResult = jcrQuery.execute();
                NodeIterator nodeIterator = queryResult.getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode().getParent();
                    FileImpl file = new FileImpl();
                    file.setBasePath(node.getPath());
                    file.setCreationDate(node.getProperty("jcr:created").getDate().getTime());
                    file.setLastModified(node.getProperty("jcr:lastModified").getDate().getTime());
                    file.setName(node.getName());
                    files.add(file);
                }
            }
        }
        catch (Exception e) {
            throw new CMSException("Cannot query the CMS with query: " + queryString, e);
        }
        return files;
    }
}

