/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.util.NodeUtil;

public class GetArchiveCommand
extends JCRCommand {
    private static final long serialVersionUID = 939158777692206676L;
    String msRootPath;
    String msLanguage;
    JCRCommandContext mContext;
    private static final int BUFFER_SIZE = 1024;

    public GetArchiveCommand(String sRootPath, String sLanguage) {
        this.msRootPath = sRootPath;
        this.msLanguage = sLanguage;
    }

    public Object execute() {
        this.mContext = this.context;
        try {
            File tmpFile = File.createTempFile("jbportal_", "_cmsexport.zip");
            ZipOutputStream outStream = new ZipOutputStream(new FileOutputStream(tmpFile.getCanonicalPath()));
            outStream = this.zipFiles(this.msRootPath, outStream);
            if (outStream != null) {
                outStream.close();
            }
            return tmpFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ZipOutputStream zipFiles(String sPath, ZipOutputStream zos) {
        try {
            Node folderNode = (Node)this.mContext.getSession().getItem(sPath);
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                int count;
                Node node = ni.nextNode();
                NodeType nt = node.getPrimaryNodeType();
                if (nt.getName().equals("portalcms:folder")) {
                    this.zipFiles(node.getPath(), zos);
                    continue;
                }
                if (!nt.getName().equals("portalcms:file")) continue;
                String diff = node.getPath();
                if (!this.msRootPath.equals("/")) {
                    diff = node.getPath().substring(NodeUtil.getParentPath(this.msRootPath).length());
                }
                JCRCommand fileList = (JCRCommand)this.mContext.getCommandFactory().createFileGetCommand(node.getPath(), new Locale(this.msLanguage));
                org.jboss.portal.cms.model.File childFile = (org.jboss.portal.cms.model.File)this.mContext.execute(fileList);
                ZipEntry entry = new ZipEntry(diff);
                zos.putNextEntry(entry);
                Content content = childFile.getContent();
                if (content == null) continue;
                BufferedInputStream is = new BufferedInputStream(content.getStream(), 1024);
                byte[] data = new byte[1024];
                while ((count = is.read(data, 0, 1024)) != -1) {
                    zos.write(data, 0, count);
                }
                is.close();
                zos.closeEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return zos;
    }
}

