/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.FolderImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.model.Folder;

public class FolderGetListCommand
extends JCRCommand {
    private static final long serialVersionUID = -754630384075659266L;
    String sFolderPath;

    public FolderGetListCommand(String sFolderPath) {
        this.sFolderPath = sFolderPath;
    }

    public Object execute() {
        try {
            FolderImpl folder = new FolderImpl();
            Node folderNode = (Node)this.context.getSession().getItem(this.sFolderPath);
            folder.setName(folderNode.getName());
            if (!"/".equals(this.sFolderPath)) {
                folder.setDescription(folderNode.getProperty("portalcms:description").getString());
                folder.setLastModified(folderNode.getProperty("portalcms:lastmodified").getDate().getTime());
            }
            folder.setBasePath(this.sFolderPath);
            ArrayList<Folder> folders = new ArrayList<Folder>();
            ArrayList<File> files = new ArrayList<File>();
            NodeIterator ni = folderNode.getNodes();
            while (ni.hasNext()) {
                try {
                    Node node = ni.nextNode();
                    NodeType nt = node.getPrimaryNodeType();
                    String ntName = nt.getName();
                    if (ntName.equals("portalcms:folder")) {
                        JCRCommand folderList = (JCRCommand)this.context.getCommandFactory().createFolderGetCommand(node.getPath());
                        Folder childFolder = (Folder)this.context.execute(folderList);
                        folders.add(childFolder);
                        continue;
                    }
                    if (!ntName.equals("portalcms:file")) continue;
                    File childFile = this.getFileMetaData(node.getPath(), this.context);
                    files.add(childFile);
                }
                catch (Exception e) {}
            }
            folder.setFolders(folders);
            folder.setFiles(files);
            return folder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getFileMetaData(String msPath, JCRCommandContext context) throws Exception {
        FileImpl file = null;
        file = new FileImpl();
        Session session = context.getSession();
        Node fileNode = (Node)session.getItem(msPath);
        fileNode = (Node)session.getItem(msPath);
        file.setCreationDate(fileNode.getProperty("jcr:created").getDate().getTime());
        file.setLastModified(fileNode.getProperty("jcr:lastModified").getDate().getTime());
        file.setBasePath(msPath);
        file.setName(fileNode.getName());
        return file;
    }
}

