/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.ArrayList;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import org.jboss.portal.cms.impl.ContentImpl;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;

public class FileGetListCommand
extends JCRCommand {
    private static final long serialVersionUID = 7601421931789710938L;
    String sFilePath;

    public FileGetListCommand(String sFilePath) {
        this.sFilePath = sFilePath;
    }

    public Object execute() {
        ArrayList<ContentImpl> contents = new ArrayList<ContentImpl>();
        try {
            FileImpl file = new FileImpl();
            Node fileNode = (Node)this.context.getSession().getItem(this.sFilePath);
            file.setName(fileNode.getName());
            file.setBasePath(this.sFilePath);
            NodeIterator ni = fileNode.getNodes();
            while (ni.hasNext()) {
                Node contentNode = ni.nextNode();
                NodeType nt = contentNode.getPrimaryNodeType();
                if (!nt.getName().equals("portalcms:content")) continue;
                ContentImpl content = new ContentImpl();
                content.setCreationDate(contentNode.getProperty("jcr:created").getDate().getTime());
                content.setLastModified(contentNode.getProperty("jcr:lastModified").getDate().getTime());
                content.setBasePath(contentNode.getPath());
                content.setDescription(contentNode.getProperty("portalcms:description").getString());
                content.setTitle(contentNode.getProperty("portalcms:title").getString());
                content.setMimeType(contentNode.getProperty("jcr:mimeType").getString());
                content.setName(contentNode.getName());
                content.setEncoding(contentNode.getProperty("jcr:encoding").getString());
                content.setStream(contentNode.getProperty("jcr:data").getStream());
                content.setLocale(new Locale(contentNode.getProperty("portalcms:language").getString()));
                if (contentNode.hasProperty("portalcms:size")) {
                    long size = Long.parseLong(contentNode.getProperty("portalcms:size").getString());
                    content.setSize(size);
                }
                contents.add(content);
            }
            return contents;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

