/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.jboss.logging.Logger;
import org.jboss.portal.cms.impl.ContentImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.util.VersionUtil;
import org.jboss.portal.cms.util.FileUtil;

public class ContentGetCommand
extends JCRCommand {
    private static final long serialVersionUID = 9075368287889393431L;
    String msPath;
    String msVersionNumber;
    Locale mlocale;
    private static Logger log = Logger.getLogger(ContentGetCommand.class);

    public ContentGetCommand(String sPath, Locale locale) {
        this(sPath, null, locale);
    }

    public ContentGetCommand(String sPath, String sVersionNumber, Locale locale) {
        this.msPath = sPath;
        this.msVersionNumber = sVersionNumber;
        this.mlocale = locale;
    }

    public Object execute() {
        try {
            if (this.mlocale == null) {
                this.mlocale = this.context.getDefaultLocale();
            }
            ContentImpl content = new ContentImpl();
            Session session = this.context.getSession();
            Node contentNode = null;
            try {
                contentNode = (Node)session.getItem(this.msPath + "/" + this.mlocale.getLanguage());
            }
            catch (PathNotFoundException e) {
                return null;
            }
            content.setCreationDate(contentNode.getProperty("jcr:created").getDate().getTime());
            content.setLastModified(contentNode.getProperty("jcr:lastModified").getDate().getTime());
            content.setBasePath(this.msPath + "/" + this.mlocale.getLanguage());
            content.setDescription(contentNode.getProperty("portalcms:description").getString());
            if (contentNode.hasProperty("portalcms:size")) {
                long size = Long.parseLong(contentNode.getProperty("portalcms:size").getString());
                content.setSize(size);
            }
            if (this.msVersionNumber == null) {
                contentNode = (Node)session.getItem(content.getBasePath());
                VersionHistory vh = contentNode.getVersionHistory();
                Version version = VersionUtil.getLiveVersion(vh);
                if (version == null) {
                    return null;
                }
                NodeIterator ni = version.getNodes();
                contentNode = ni.nextNode();
                content.setCreationDate(version.getCreated().getTime());
                content.setVersionNumber(version.getName());
                content.setVersionPath(version.getPath());
                content.setVersionUUID(version.getUUID());
                content.setLive(true);
            } else {
                VersionHistory vh = contentNode.getVersionHistory();
                Version liveVersion = VersionUtil.getLiveVersion(vh);
                VersionIterator vi = vh.getAllVersions();
                while (vi.hasNext()) {
                    Version version = vi.nextVersion();
                    if (!this.msVersionNumber.equals(version.getName())) continue;
                    NodeIterator ni = version.getNodes();
                    contentNode = ni.nextNode();
                    content.setCreationDate(version.getCreated().getTime());
                    content.setVersionNumber(version.getName());
                    content.setVersionPath(version.getPath());
                    content.setVersionUUID(version.getUUID());
                    if (liveVersion == null || !liveVersion.getName().equals(version.getName())) break;
                    content.setLive(true);
                    break;
                }
            }
            content.setTitle(contentNode.getProperty("portalcms:title").getString());
            content.setMimeType(contentNode.getProperty("jcr:mimeType").getString());
            content.setName(contentNode.getName());
            content.setEncoding(contentNode.getProperty("jcr:encoding").getString());
            content.setBytes(FileUtil.getBytes(contentNode.getProperty("jcr:data").getStream()));
            content.setLocale(new Locale(contentNode.getProperty("portalcms:language").getString()));
            return content;
        }
        catch (Exception e) {
            log.error((Object)"Cannot get content", (Throwable)e);
            return null;
        }
    }
}

