/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.value.StringValue;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.impl.jcr.util.VersionUtil;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.identity.User;

public class ContentCreateNewVersionCommand
extends JCRCommand {
    private static final long serialVersionUID = -4055346144913229565L;
    List mContents = new ArrayList();
    boolean bMakeLive;

    public ContentCreateNewVersionCommand(Content content, boolean bMakeLive) {
        this.mContents.add(content);
        this.bMakeLive = bMakeLive;
    }

    public ContentCreateNewVersionCommand(List contents, boolean bMakeLive) {
        this.mContents = contents;
        this.bMakeLive = bMakeLive;
    }

    public Object execute() {
        try {
            Scope scope = JCRCommandContext.scope;
            for (int i = 0; i < this.mContents.size(); ++i) {
                Content content = (Content)this.mContents.get(i);
                Node contentNode = (Node)this.context.getSession().getItem(content.getBasePath());
                User user = (User)this.context.getAttribute(scope, "user");
                if (user != null) {
                    contentNode.setProperty("portalcms:user", user.getUserName());
                }
                contentNode.setProperty("portalcms:size", (Value)new StringValue(String.valueOf(content.getBytes().length)));
                this.context.getSession().save();
                String processId = (String)this.context.getAttribute(scope, "processid");
                if (this.bMakeLive && processId != null && processId.trim().length() != 0) {
                    contentNode.setProperty("portalcms:processid", processId);
                    this.context.getSession().save();
                    VersionUtil.createVersion(contentNode, false);
                    continue;
                }
                contentNode.setProperty("portalcms:processid", (String)null);
                contentNode.save();
                VersionUtil.createVersion(contentNode, this.bMakeLive);
            }
            this.context.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return null;
    }
}

