/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.StringValue;
import org.jboss.portal.cms.CMSMimeMappings;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.impl.jcr.command.FileBasedJCRCommand;
import org.jboss.portal.cms.model.File;

public class ContentCreateCommand
extends FileBasedJCRCommand {
    private static final long serialVersionUID = -2843288770902185840L;

    public ContentCreateCommand(File file) {
        super(file);
    }

    public Object execute() {
        try {
            String basePath = this.mFile.getBasePath();
            JCRCommandContext context = (JCRCommandContext)this.getContext();
            Node fileNode = (Node)context.getSession().getItem(basePath);
            Node contentNode = fileNode.addNode(this.mFile.getContent().getLocale().getLanguage(), "portalcms:content");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:data", (Value)new BinaryValue(this.mFile.getContent().getBytes()));
            contentNode.setProperty("jcr:lastModified", (Value)new DateValue(Calendar.getInstance()));
            contentNode.setProperty("portalcms:description", (Value)new StringValue(this.mFile.getContent().getDescription()));
            contentNode.setProperty("portalcms:title", (Value)new StringValue(this.mFile.getContent().getTitle()));
            contentNode.setProperty("portalcms:language", (Value)new StringValue(this.mFile.getContent().getLocale().getLanguage()));
            contentNode.setProperty("portalcms:size", (Value)new StringValue(String.valueOf(this.mFile.getContent().getBytes().length)));
            if (this.mFile.getContent().getMimeType() != null) {
                contentNode.setProperty("jcr:mimeType", this.mFile.getContent().getMimeType());
            } else {
                CMSMimeMappings mapper = new CMSMimeMappings();
                String fileExt = basePath.substring(basePath.lastIndexOf(".") + 1, basePath.length());
                if (mapper.getMimeType(fileExt) != null) {
                    contentNode.setProperty("jcr:mimeType", mapper.getMimeType(fileExt));
                } else {
                    contentNode.setProperty("jcr:mimeType", "application/octet-stream");
                }
            }
            contentNode.addMixin("mix:versionable");
            context.getSession().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

