/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.io.File;
import java.io.FileOutputStream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipFile;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.cms.CMS;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.jcr.JCRCMS;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;

public class AsyncStoreArchiveCommand
extends JCRCommand {
    private static final long serialVersionUID = 1568453649437987499L;
    private static Logger log = Logger.getLogger(AsyncStoreArchiveCommand.class);
    String msRootPath;
    byte[] archiveBytes;
    String msLanguage;
    private Object user = null;
    private Object approvePublishWorkflow = null;

    public AsyncStoreArchiveCommand(String sRootPath, byte[] archiveBytes, String sLanguage) {
        this.msRootPath = sRootPath;
        this.archiveBytes = archiveBytes;
        this.msLanguage = sLanguage;
    }

    public Object execute() {
        try {
            this.user = this.context.getAttribute(JCRCommandContext.scope, "user");
            this.approvePublishWorkflow = this.context.getAttribute(JCRCommandContext.scope, "approvePublishWorkflow");
            this.validateArchive();
            Thread t = new Thread(new AsyncProcessor());
            t.start();
            return null;
        }
        catch (Exception e) {
            if (e instanceof CMSException) {
                throw (CMSException)e;
            }
            throw new CMSException(e);
        }
    }

    private void validateArchive() throws CMSException {
        try {
            File tmpFile = this.getZipFile();
            ZipFile zipFile = new ZipFile(tmpFile);
        }
        catch (Exception e) {
            throw new CMSException(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getZipFile() throws Exception {
        File zipFile = null;
        zipFile = File.createTempFile("jbportal_", "_cmsimport.zip");
        FileOutputStream fos = new FileOutputStream(zipFile.getCanonicalPath());
        try {
            fos.write(this.archiveBytes);
            fos.close();
        }
        finally {
            fos.close();
        }
        return zipFile;
    }

    private class AsyncProcessor
    implements Runnable {
        private AsyncProcessor() {
        }

        public void run() {
            try {
                log.info((Object)"Async Processing started....................");
                JCRCMS.getUserInfo().set(AsyncStoreArchiveCommand.this.user);
                if (AsyncStoreArchiveCommand.this.approvePublishWorkflow != null) {
                    JCRCMS.turnOnWorkflow();
                }
                CMS cms = this.findCMSService();
                JCRCommand storeArchiveCommand = (JCRCommand)cms.getCommandFactory().createStoreArchiveCommand(AsyncStoreArchiveCommand.this.msRootPath, AsyncStoreArchiveCommand.this.archiveBytes, AsyncStoreArchiveCommand.this.msLanguage);
                cms.execute(storeArchiveCommand);
                log.info((Object)"Async Processing finished..................");
            }
            catch (Exception e) {
                log.error((Object)"Asynchronous Processing of archive failed------------------------------------");
                log.error((Object)this, (Throwable)e);
                log.error((Object)"-----------------------------------------------------------------------------");
            }
        }

        private CMS findCMSService() throws Exception {
            MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
            return (CMS)MBeanProxy.get(CMS.class, (ObjectName)new ObjectName("portal:service=CMS"), (MBeanServer)mbeanServer);
        }
    }
}

