/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.command.ContentCreateCommand;
import org.jboss.portal.cms.impl.jcr.command.CopyCommand;
import org.jboss.portal.cms.impl.jcr.command.DeleteCommand;
import org.jboss.portal.cms.impl.jcr.command.FileCreateCommand;
import org.jboss.portal.cms.impl.jcr.command.FileGetCommand;
import org.jboss.portal.cms.impl.jcr.command.FileGetListCommand;
import org.jboss.portal.cms.impl.jcr.command.FileUpdateCommand;
import org.jboss.portal.cms.impl.jcr.command.FolderCreateCommand;
import org.jboss.portal.cms.impl.jcr.command.FolderGetCommand;
import org.jboss.portal.cms.impl.jcr.command.FolderGetListCommand;
import org.jboss.portal.cms.impl.jcr.command.MoveCommand;
import org.jboss.portal.cms.impl.jcr.command.StoreArchiveCommand;
import org.jboss.portal.cms.impl.jcr.composite.NewFileCommand;
import org.jboss.portal.cms.impl.jcr.composite.UpdateFileCommand;
import org.jboss.portal.cms.security.AuthorizationManager;
import org.jboss.portal.cms.security.Criteria;
import org.jboss.portal.cms.security.Permission;
import org.jboss.portal.cms.security.PortalCMSSecurityContext;
import org.jboss.portal.cms.util.NodeUtil;
import org.jboss.portal.cms.workflow.ApprovePublish;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;

public class ACLEnforcer {
    private Map<Type, List<String>> aclCommands = new HashMap<Type, List<String>>();
    private AuthorizationManager authorizationManager = null;

    public ACLEnforcer(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
        String packageName = "org.jboss.portal.cms.impl.jcr.command.";
        this.addACLCommand(Type.READ, packageName + "FolderGetListCommand");
        this.addACLCommand(Type.READ, packageName + "FolderGetCommand");
        this.addACLCommand(Type.READ, packageName + "FileGetListCommand");
        this.addACLCommand(Type.READ, packageName + "FileGetCommand");
        this.addACLCommand(Type.WRITE, packageName + "ContentCreateCommand");
        this.addACLCommand(Type.WRITE, packageName + "FileCreateCommand");
        this.addACLCommand(Type.WRITE, packageName + "FolderCreateCommand");
        this.addACLCommand(Type.WRITE, packageName + "FileUpdateCommand");
        this.addACLCommand(Type.WRITE, packageName + "StoreArchiveCommand");
        this.addACLCommand(Type.WRITE, "org.jboss.portal.cms.impl.jcr.composite.NewFileCommand");
        this.addACLCommand(Type.WRITE, "org.jboss.portal.cms.impl.jcr.composite.UpdateFileCommand");
        this.addACLCommand(Type.MANAGE, packageName + "CopyCommand");
        this.addACLCommand(Type.MANAGE, packageName + "DeleteCommand");
        this.addACLCommand(Type.MANAGE, packageName + "MoveCommand");
    }

    protected void addACLCommand(Type type, String commandClassName) {
        if (type == null || type == Type.UNKNOWN) {
            throw new IllegalArgumentException("Type cannot be null or of type UNKNOWN");
        }
        List<String> commands = this.aclCommands.get((Object)type);
        if (commands == null) {
            commands = new ArrayList<String>();
        }
        commands.add(commandClassName);
        this.aclCommands.put(type, commands);
    }

    public boolean hasAccess(PortalCMSSecurityContext cmsSecurityContext) {
        boolean hasAccess = true;
        User loggedInUser = (User)cmsSecurityContext.getIdentity();
        JCRCommand command = (JCRCommand)cmsSecurityContext.getAttribute("command");
        Type actionType = Type.UNKNOWN;
        if (command != null) {
            actionType = this.getActionType(command);
        }
        switch (actionType) {
            case READ: {
                hasAccess = this.hasReadAccess(loggedInUser, command);
                break;
            }
            case WRITE: {
                hasAccess = this.hasWriteAccess(loggedInUser, command);
                break;
            }
            case MANAGE: {
                hasAccess = this.hasManageAccess(loggedInUser, command);
                break;
            }
            default: {
                if (cmsSecurityContext.getAttribute("applyFilter") != null) {
                    String path = (String)cmsSecurityContext.getAttribute("applyFilter");
                    Boolean isFolder = (Boolean)cmsSecurityContext.getAttribute("isFolder");
                    if (isFolder.booleanValue()) {
                        hasAccess = this.hasReadAccess(loggedInUser, path);
                        break;
                    }
                    hasAccess = this.hasWriteAccess(loggedInUser, path);
                    break;
                }
                if (cmsSecurityContext.getAttribute("path") != null) {
                    String path = (String)cmsSecurityContext.getAttribute("path");
                    hasAccess = this.computeAccess(loggedInUser, path, "read");
                    break;
                }
                if (cmsSecurityContext.getAttribute("manageWorkflow") == null) break;
                ApprovePublish service = (ApprovePublish)cmsSecurityContext.getAttribute("approvePublish");
                hasAccess = this.computeWorkflowManagementAccess(loggedInUser, service.getManagers());
            }
        }
        return hasAccess;
    }

    private Type getActionType(JCRCommand command) {
        for (Type type : Type.values()) {
            List<String> commands = this.aclCommands.get((Object)type);
            if (commands == null || !commands.contains(command.getClass().getName())) continue;
            return type;
        }
        return Type.UNKNOWN;
    }

    protected boolean hasReadAccess(User user, JCRCommand command) {
        boolean hasReadAccess = false;
        String path = null;
        if (command instanceof FolderGetListCommand) {
            path = ((FolderGetListCommand)command).sFolderPath;
        } else if (command instanceof FolderGetCommand) {
            path = ((FolderGetCommand)command).msPath;
        } else if (command instanceof FileGetCommand) {
            path = ((FileGetCommand)command).path;
        } else if (command instanceof FileGetListCommand) {
            path = ((FileGetListCommand)command).sFilePath;
        }
        if (path != null) {
            hasReadAccess = this.hasReadAccess(user, path);
        }
        return hasReadAccess;
    }

    protected boolean hasReadAccess(User user, String path) {
        boolean hasAccess = this.computeAccess(user, path, "read");
        if (!hasAccess && !(hasAccess = this.computeAccess(user, path, "write"))) {
            hasAccess = this.computeAccess(user, path, "manage");
        }
        return hasAccess;
    }

    protected boolean hasWriteAccess(User user, JCRCommand command) {
        boolean hasWriteAccess = false;
        String path = null;
        if (command instanceof ContentCreateCommand) {
            path = ((ContentCreateCommand)command).mFile.getBasePath();
        } else if (command instanceof FileCreateCommand) {
            path = ((FileCreateCommand)command).mFile.getBasePath();
        } else if (command instanceof FolderCreateCommand) {
            try {
                path = NodeUtil.getParentPath(((FolderCreateCommand)command).mFolder.getBasePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (command instanceof FileUpdateCommand) {
            path = ((FileUpdateCommand)command).mFile.getBasePath();
        } else if (command instanceof StoreArchiveCommand) {
            path = ((StoreArchiveCommand)command).msRootPath;
        } else if (command instanceof NewFileCommand) {
            try {
                path = NodeUtil.getParentPath(((NewFileCommand)command).getPath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (command instanceof UpdateFileCommand) {
            path = ((UpdateFileCommand)command).getPath();
        }
        if (path != null && !(hasWriteAccess = this.computeAccess(user, path, "write"))) {
            hasWriteAccess = this.computeAccess(user, path, "manage");
        }
        return hasWriteAccess;
    }

    protected boolean hasWriteAccess(User user, String path) {
        boolean hasAccess = this.computeAccess(user, path, "write");
        if (!hasAccess) {
            hasAccess = this.computeAccess(user, path, "manage");
        }
        return hasAccess;
    }

    protected boolean hasManageAccess(User user, JCRCommand command) {
        boolean hasManageAccess = false;
        String path = null;
        if (command instanceof CopyCommand) {
            path = ((CopyCommand)command).msFromPath;
            hasManageAccess = this.computeAccess(user, path, "manage");
            if (hasManageAccess) {
                path = ((CopyCommand)command).msToPath;
                hasManageAccess = this.computeAccess(user, path, "manage");
            }
        } else if (command instanceof DeleteCommand) {
            path = ((DeleteCommand)command).msPath;
            hasManageAccess = this.computeAccess(user, path, "manage");
        } else if (command instanceof MoveCommand && (hasManageAccess = this.computeAccess(user, path = ((MoveCommand)command).msFromPath, "manage"))) {
            path = ((MoveCommand)command).msToPath;
            hasManageAccess = this.computeAccess(user, path, "manage");
        }
        return hasManageAccess;
    }

    protected boolean computeAccess(User user, String path, String action) {
        boolean hasAccess = false;
        User root = this.authorizationManager.getProvider().getRoot();
        if (user != null && user.getUserName() != null && user.getUserName().equals(root.getUserName())) {
            return true;
        }
        Collection userPermissions = this.getPermissions(user);
        Collection specificPermissions = this.getPermissions(path);
        for (Permission specificPermission : specificPermissions) {
            if (!specificPermission.getService().equals("cms") || !specificPermission.getAction().equals(action)) continue;
            for (Permission userPermission : userPermissions) {
                String pathCriteria;
                if (!userPermission.getService().equals("cms") || !userPermission.getAction().equals(action) || !(pathCriteria = userPermission.findCriteriaValue("path")).equals(path)) continue;
                hasAccess = true;
            }
        }
        if (specificPermissions != null && !specificPermissions.isEmpty()) {
            return hasAccess;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        StringBuffer buffer = new StringBuffer("/");
        ArrayList<String> list = new ArrayList<String>();
        list.add(new String(buffer.toString()));
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            buffer.append(token);
            list.add(buffer.toString());
            if (!st.hasMoreTokens()) continue;
            buffer.append("/");
        }
        boolean explicitPermissionsFound = false;
        for (String currentPath : list) {
            Collection permissions = this.getPermissions(currentPath);
            if (permissions == null || permissions.isEmpty()) continue;
            explicitPermissionsFound = true;
            boolean accessFound = false;
            for (Permission nodePermission : permissions) {
                if (nodePermission.getService().equals("cms") && nodePermission.getAction().equals(action)) {
                    for (Permission userPermission : userPermissions) {
                        String pathCriteria;
                        if (!userPermission.getService().equals("cms") || !this.isActionImplied(userPermission.getAction(), action) || !(pathCriteria = userPermission.findCriteriaValue("path")).equals(currentPath)) continue;
                        accessFound = true;
                    }
                }
                if (!accessFound) continue;
                break;
            }
            if (accessFound) continue;
            return false;
        }
        hasAccess = explicitPermissionsFound;
        return hasAccess;
    }

    private boolean computeWorkflowManagementAccess(User user, Set managerRoles) {
        if (managerRoles == null || managerRoles.isEmpty()) {
            return false;
        }
        try {
            boolean hasAccess = false;
            Set userRoles = this.authorizationManager.getProvider().getMembershipModule().getRoles(user);
            if (userRoles != null) {
                for (Role userRole : userRoles) {
                    String userRoleName = userRole.getName();
                    if (!managerRoles.contains(userRoleName)) continue;
                    hasAccess = true;
                    break;
                }
            }
            return hasAccess;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Collection getPermissions(User user) {
        Set permissions = null;
        if (user != null) {
            String userId = user.getUserName();
            String uri = this.authorizationManager.getProvider().getUserURI(userId);
            permissions = this.authorizationManager.getProvider().getSecurityBindings(uri);
        } else {
            String uri = this.authorizationManager.getProvider().getRoleURI("Anonymous");
            permissions = this.authorizationManager.getProvider().getSecurityBindings(uri);
        }
        return permissions;
    }

    private Collection getPermissions(String path) {
        Criteria criteria = new Criteria("path", path);
        String uri = this.authorizationManager.getProvider().getCriteriaURI(criteria.getName(), criteria.getValue());
        return this.authorizationManager.getProvider().getSecurityBindings(uri);
    }

    private boolean isActionImplied(String action, String impliedTarget) {
        boolean implied = false;
        if (impliedTarget.equalsIgnoreCase("read")) {
            if (action.equalsIgnoreCase("read") || action.equalsIgnoreCase("write") || action.equalsIgnoreCase("manage")) {
                implied = true;
            }
        } else if (impliedTarget.equalsIgnoreCase("write")) {
            if (action.equalsIgnoreCase("write") || action.equalsIgnoreCase("manage")) {
                implied = true;
            }
        } else if (impliedTarget.equalsIgnoreCase("manage") && action.equalsIgnoreCase("manage")) {
            implied = true;
        }
        return implied;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        READ,
        WRITE,
        MANAGE,
        UNKNOWN;

    }
}

