/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Session;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandFactory;
import org.jboss.portal.common.invocation.AbstractInvocationContext;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.common.invocation.resolver.MapAttributeResolver;

public class JCRCommandContext
extends AbstractInvocationContext
implements Serializable {
    public static final Scope scope = Scope.THREAD_SCOPE;
    private final transient Session session;
    private final transient JCRCommandFactory commandFactory;
    private final transient Locale locale;
    private Map clusterContext = null;

    public JCRCommandContext(Session session, JCRCommandFactory factory, Locale locale) {
        this.session = session;
        this.commandFactory = factory;
        this.locale = locale;
        this.addResolver(scope, (AttributeResolver)new MapAttributeResolver());
    }

    public JCRCommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public Session getSession() {
        return this.session;
    }

    public Object execute(JCRCommand cmd) throws CMSException {
        cmd.setContext(this);
        return cmd.execute();
    }

    public Locale getDefaultLocale() {
        return this.locale;
    }

    public void setClusterContextInfo(String key, Object data) {
        this.getClusterContext().put(key, data);
    }

    public Object getClusterContextInfo(String key) {
        return this.getClusterContext().get(key);
    }

    private Map getClusterContext() {
        if (this.clusterContext == null) {
            this.clusterContext = new HashMap();
        }
        return this.clusterContext;
    }
}

