/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.jcr;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.transaction.TransactionManager;
import org.apache.jackrabbit.core.XASession;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jboss.cache.Version;
import org.jboss.portal.cms.CMS;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.CMSMimeMappings;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.CommandFactory;
import org.jboss.portal.cms.impl.ContentImpl;
import org.jboss.portal.cms.impl.FileImpl;
import org.jboss.portal.cms.impl.FolderImpl;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.impl.jcr.JCRCommandFactory;
import org.jboss.portal.cms.impl.jcr.JCRService;
import org.jboss.portal.cms.impl.jcr.JackRabbitTransaction;
import org.jboss.portal.cms.impl.jcr.jackrabbit.JackrabbitJCRService;
import org.jboss.portal.cms.model.CMSUser;
import org.jboss.portal.cms.security.AuthorizationManager;
import org.jboss.portal.cms.util.HibernateUtil;
import org.jboss.portal.cms.util.RepositoryUtil;
import org.jboss.portal.cms.workflow.ApprovePublish;
import org.jboss.portal.common.invocation.InterceptorStackFactory;
import org.jboss.portal.common.invocation.Invocation;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.invocation.InvocationHandler;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.net.URLNavigator;
import org.jboss.portal.common.net.URLVisitor;
import org.jboss.portal.common.transaction.TransactionManagerProvider;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.identity.User;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.util.StopWatch;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRCMS
extends AbstractJBossService
implements CMS {
    private static Logger log = Logger.getLogger(JCRCMS.class);
    private JCRCommandFactory commandFactory;
    private boolean doChecking;
    private Locale defaultLocale;
    private JCRService jcr;
    private String defaultContentLocation;
    private String homeDir;
    private String repositoryName;
    private InterceptorStackFactory stackFactory;
    private Element config;
    private AuthorizationManager authorizationManager;
    private ApprovePublish approvePublishWorkflow;
    private String jndiName;
    private JNDI.Binding jndiBinding;
    private String cmsSessionFactory;
    private boolean isServiceAvailable;
    private InvocationHandler handler = new InvocationHandler(){

        public Object invoke(Invocation invocation) throws Exception, InvocationException {
            JCRCommand cmd = (JCRCommand)invocation;
            return cmd.execute();
        }
    };
    protected static ThreadLocal userInfo = new ThreadLocal();
    protected static ThreadLocal turnOffWorkflow = new ThreadLocal();
    protected static ThreadLocal applyUISecurityFilter = new ThreadLocal();
    protected static ThreadLocal userRoles = new ThreadLocal();

    public static ThreadLocal getUserInfo() {
        return userInfo;
    }

    public static void turnOffWorkflow() {
        turnOffWorkflow.set(new Boolean(true));
    }

    public static void turnOnWorkflow() {
        turnOffWorkflow.set(null);
    }

    public static void enableUISecurityFilter() {
        applyUISecurityFilter.set(Boolean.TRUE);
    }

    public static void disableUISecurityFilter() {
        applyUISecurityFilter.set(null);
    }

    public static boolean isUISecurityFilterActive() {
        boolean isUISecurityFilterActive = false;
        if (applyUISecurityFilter.get() != null && ((Boolean)applyUISecurityFilter.get()).booleanValue()) {
            isUISecurityFilterActive = true;
        }
        return isUISecurityFilterActive;
    }

    public static Set<String> getRoles() {
        return (Set)userRoles.get();
    }

    public static void setRoles(Set<String> roles) {
        userRoles.set(roles);
    }

    public JCRCMS() {
        this.commandFactory = new JCRCommandFactory();
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public String getDefaultContentLocation() {
        return this.defaultContentLocation;
    }

    public void setDefaultContentLocation(String defaultContentLocation) {
        this.defaultContentLocation = defaultContentLocation;
    }

    public Element getConfig() {
        return this.config;
    }

    public void setConfig(Element config) {
        this.config = config;
    }

    public JCRService getJCR() {
        return this.jcr;
    }

    @Override
    public String getDefaultLocale() {
        return this.defaultLocale.getLanguage();
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = new Locale(defaultLocale);
    }

    public boolean getDoChecking() {
        return this.doChecking;
    }

    public void setDoChecking(boolean doChecking) {
        this.doChecking = doChecking;
    }

    public ApprovePublish getApprovePublishWorkflow() {
        return this.approvePublishWorkflow;
    }

    public void setApprovePublishWorkflow(ApprovePublish approvePublishWorkflow) {
        this.approvePublishWorkflow = approvePublishWorkflow;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public Repository getRepository() {
        return this.jcr.getRepository();
    }

    @Override
    public boolean isWorkflowActivated() {
        return this.approvePublishWorkflow != null;
    }

    public void setStackFactory(InterceptorStackFactory stackFactory) {
        this.stackFactory = stackFactory;
    }

    public InterceptorStackFactory getStackFactory() {
        return this.stackFactory;
    }

    public String getCmsSessionFactory() {
        return this.cmsSessionFactory;
    }

    public void setCmsSessionFactory(String cmsSessionFactory) {
        this.cmsSessionFactory = cmsSessionFactory;
    }

    public void startService() throws Exception {
        block5: {
            TransactionManager tm = null;
            boolean isStartedHere = false;
            try {
                tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
                if (tm.getStatus() == 6) {
                    tm.begin();
                    isStartedHere = true;
                }
                if (this.jndiName != null) {
                    this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
                    this.jndiBinding.bind();
                }
                String cacheVersion = Version.getVersionString((short)Version.getVersionShort());
                log.info((Object)("JBossCache Version=" + cacheVersion));
                StopWatch watch = new StopWatch(true);
                log.info((Object)"Starting JCR CMS");
                this.startJCR();
                watch.stop();
                log.info((Object)("Started JCR CMS in: " + watch));
                if (isStartedHere) {
                    tm.commit();
                }
                this.isServiceAvailable = true;
            }
            catch (Exception e) {
                log.error((Object)this, (Throwable)e);
                if (!isStartedHere) break block5;
                tm.rollback();
            }
        }
    }

    public void stopService() {
        this.isServiceAvailable = false;
        TransactionManager tm = null;
        boolean isStartedHere = false;
        try {
            tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
            if (tm.getStatus() == 6) {
                tm.begin();
                isStartedHere = true;
            }
            if (this.jndiBinding != null) {
                this.jndiBinding.unbind();
                this.jndiBinding = null;
            }
            log.info((Object)"Stopping JCR CMS");
            this.stopJCR();
            if (isStartedHere) {
                tm.commit();
            }
        }
        catch (Exception e) {
            try {
                if (isStartedHere) {
                    tm.rollback();
                }
            }
            catch (Exception rbe) {
                throw new RuntimeException(rbe);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object execute(Command cmd) throws CMSException {
        if (!this.isServiceAvailable) {
            throw new CMSException(2);
        }
        return this.executeCommand(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentExists() throws Exception {
        boolean bl;
        Session session = null;
        try {
            session = this.jcr.login("anonid", "");
            bl = session.itemExists("/default");
        }
        catch (Throwable throwable) {
            RepositoryUtil.safeLogout(session);
            throw throwable;
        }
        RepositoryUtil.safeLogout(session);
        return bl;
    }

    private Object executeCommand(Command cmd) throws CMSException {
        XASession session = null;
        Object obj = null;
        boolean isClusterDelegatedRequest = false;
        boolean clusterWorkflowStatus = false;
        TransactionManager tm = null;
        JackRabbitTransaction tx = null;
        boolean isStartedHere = false;
        try {
            tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
            isStartedHere = false;
            if (tm.getStatus() == 6) {
                tm.begin();
                isStartedHere = true;
            }
            session = (XASession)this.jcr.login("anonid", "");
            tx = new JackRabbitTransaction((Session)session);
            tx.begin();
            JCRCommandContext propagatedContext = (JCRCommandContext)((JCRCommand)cmd).getContext();
            if (propagatedContext != null) {
                Set roles;
                Boolean enableUISecurityFilter;
                Boolean workflowStatus;
                CMSUser propagatedUser = (CMSUser)propagatedContext.getClusterContextInfo("user");
                if (propagatedUser != null) {
                    JCRCMS.getUserInfo().set(propagatedUser);
                    isClusterDelegatedRequest = true;
                }
                if ((workflowStatus = (Boolean)propagatedContext.getClusterContextInfo("workflowStatus")) != null) {
                    JCRCMS.turnOffWorkflow();
                    clusterWorkflowStatus = true;
                }
                if ((enableUISecurityFilter = (Boolean)propagatedContext.getClusterContextInfo("enableUISecurityFilter")) != null) {
                    JCRCMS.enableUISecurityFilter();
                }
                if ((roles = (Set)propagatedContext.getClusterContextInfo("roles")) != null) {
                    JCRCMS.setRoles(roles);
                }
            }
            JCRCommand jcrCmd = (JCRCommand)cmd;
            JCRCommandContext ctx = new JCRCommandContext((Session)session, this.commandFactory, this.defaultLocale);
            jcrCmd.setContext(ctx);
            ctx.setAttribute(JCRCommandContext.scope, "user", JCRCMS.getUserInfo().get());
            Object isWorkflowOff = turnOffWorkflow.get();
            if (this.approvePublishWorkflow != null && isWorkflowOff == null) {
                ctx.setAttribute(JCRCommandContext.scope, "approvePublishWorkflow", this.approvePublishWorkflow);
            }
            if (this.stackFactory != null && this.stackFactory.getInterceptorStack().getLength() != 0) {
                jcrCmd.setHandler(this.handler);
                obj = jcrCmd.invoke(this.stackFactory.getInterceptorStack());
                jcrCmd.setHandler(null);
            } else {
                obj = jcrCmd.execute();
            }
            session.save();
            tx.commit();
            org.hibernate.classic.Session hibSession = HibernateUtil.getSessionFactory(this.cmsSessionFactory).getCurrentSession();
            hibSession.flush();
            hibSession.clear();
            if (isStartedHere) {
                tm.commit();
            }
        }
        catch (Exception e) {
            log.error((Object)this, (Throwable)e);
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception rbe) {
                    log.error((Object)this, (Throwable)rbe);
                }
            }
            if (isStartedHere) {
                try {
                    tm.rollback();
                }
                catch (Exception rbe) {
                    log.error((Object)this, (Throwable)rbe);
                }
            }
            if (e instanceof CMSException) {
                throw (CMSException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new CMSException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            if (isClusterDelegatedRequest) {
                JCRCMS.getUserInfo().set(null);
            }
            if (clusterWorkflowStatus) {
                JCRCMS.turnOnWorkflow();
            }
        }
        return obj;
    }

    private void startJCR() throws Exception {
        DOMImplementation impl = this.config.getOwnerDocument().getImplementation();
        Document doc = impl.createDocument("tmp", "tmp", null);
        Element copy = (Element)doc.importNode(this.config, true);
        doc.removeChild(doc.getDocumentElement());
        doc.appendChild(copy);
        String result = XMLTools.toString((Document)doc);
        log.debug((Object)("Jackrabbit configuration : " + result));
        JackrabbitJCRService jr = new JackrabbitJCRService();
        jr.setHomeDir(this.homeDir);
        jr.setConfig(result);
        jr.setRepositoryName(this.repositoryName);
        jr.start();
        this.jcr = jr;
        Logger.getLogger((String)"org.apache.jackrabbit").setLevel(Level.ERROR);
        if (this.doChecking && !this.contentExists()) {
            this.createContent();
        }
    }

    private void stopJCR() {
        this.jcr.stop();
        this.jcr = null;
    }

    private void createContent() throws Exception {
        User user;
        log.info((Object)"Creating default CMS content.");
        URL root = Thread.currentThread().getContextClassLoader().getResource(this.defaultContentLocation);
        if (this.authorizationManager != null && (user = this.authorizationManager.getProvider().getRoot()) != null) {
            JCRCMS.getUserInfo().set(user);
        }
        URLVisitor visitor = new URLVisitor(){
            LinkedList atoms = new LinkedList();

            public void startDir(URL url, String name) {
                StringBuffer tmp = new StringBuffer();
                for (String atom : this.atoms) {
                    tmp.append("/").append(atom);
                }
                tmp.append("/").append(name);
                String uri = tmp.toString();
                FolderImpl folder = new FolderImpl();
                folder.setCreationDate(new Date());
                folder.setDescription(name);
                folder.setTitle(name);
                folder.setLastModified(new Date());
                folder.setName(name);
                folder.setBasePath(uri);
                log.info((Object)("Creating folder " + uri));
                Command saveCMD = JCRCMS.this.getCommandFactory().createFolderSaveCommand(folder);
                try {
                    JCRCMS.this.executeCommand(saveCMD);
                }
                catch (CMSException e) {
                    e.printStackTrace();
                }
                this.atoms.addLast(name);
            }

            public void endDir(URL url, String name) {
                this.atoms.removeLast();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void file(URL url, String name) {
                Closeable in = null;
                try {
                    StringBuffer tmp = new StringBuffer();
                    for (String atom : this.atoms) {
                        tmp.append("/").append(atom);
                    }
                    tmp.append("/").append(name);
                    String uri = tmp.toString();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream urlin = null;
                    try {
                        urlin = url.openStream();
                        IOTools.copy((InputStream)urlin, (OutputStream)baos);
                    }
                    finally {
                        IOTools.safeClose((Closeable)urlin);
                    }
                    log.info((Object)("Creating file " + uri));
                    FileImpl file = new FileImpl();
                    file.setBasePath(uri);
                    ContentImpl content = new ContentImpl();
                    content.setEncoding("UTF-8");
                    content.setTitle("JBoss Portal");
                    content.setDescription("JBoss Portal");
                    content.setBasePath(uri + "/" + JCRCMS.this.getDefaultLocale());
                    content.setBytes(baos.toByteArray());
                    String fileExt = file.getBasePath().substring(file.getBasePath().lastIndexOf(".") + 1, file.getBasePath().length());
                    CMSMimeMappings mapper = new CMSMimeMappings();
                    if (mapper.getMimeType(fileExt) != null) {
                        content.setMimeType(mapper.getMimeType(fileExt));
                    } else {
                        content.setMimeType("application/octet-stream");
                    }
                    file.setContent(new Locale(JCRCMS.this.getDefaultLocale()), content);
                    Command newFileCMD = JCRCMS.this.getCommandFactory().createNewFileCommand(file, content);
                    JCRCMS.turnOffWorkflow();
                    JCRCMS.this.executeCommand(newFileCMD);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    IOTools.safeClose(in);
                }
            }
        };
        URLNavigator.visit((URL)root, (URLVisitor)visitor);
        log.info((Object)"Default content created.");
    }
}

