/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.interceptors;

import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.portal.cms.CMSInterceptor;
import org.jboss.portal.cms.impl.CMSCacheException;
import org.jboss.portal.cms.impl.CMSTreeCacheService;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.command.DeleteCommand;
import org.jboss.portal.cms.impl.jcr.command.FileGetCommand;
import org.jboss.portal.cms.impl.jcr.composite.UpdateFileCommand;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.common.invocation.InvocationException;

public class CacheInterceptor
extends CMSInterceptor {
    private CMSTreeCacheService cache;
    public Logger log = Logger.getLogger(CacheInterceptor.class);

    private void loadCache() {
        try {
            InitialContext ic = new InitialContext();
            this.cache = (CMSTreeCacheService)ic.lookup("java:/portal/cms/CMSTreeCache");
        }
        catch (NamingException e) {
            this.log.warn((Object)"CMSTreeCache service in not available in the JNDI Tree as: java:/portal/cms/CMSTreeCache");
        }
    }

    protected Object invoke(JCRCommand invocation) throws Exception, InvocationException {
        if (this.cache == null) {
            this.loadCache();
        }
        if (invocation instanceof DeleteCommand) {
            DeleteCommand dc = (DeleteCommand)invocation;
            String path = dc.getPath();
            try {
                this.log.trace((Object)(path + " removed from cache"));
                this.cache.remove(path);
            }
            catch (CMSCacheException e) {
                e.printStackTrace();
            }
            return invocation.invokeNext();
        }
        if (invocation instanceof UpdateFileCommand) {
            UpdateFileCommand ufc = (UpdateFileCommand)invocation;
            try {
                String path = ufc.getPath();
                Locale locale = ufc.getLocale();
                this.log.trace((Object)(path + "/" + locale + " removed from cache"));
                this.cache.remove(path, locale);
            }
            catch (CMSCacheException e) {
                e.printStackTrace();
            }
            return invocation.invokeNext();
        }
        if (invocation instanceof FileGetCommand) {
            Locale locale;
            FileGetCommand fgc = (FileGetCommand)invocation;
            String path = fgc.getPath();
            File file = this.cache.get(path, locale = fgc.getLocale());
            if (file != null) {
                this.log.trace((Object)(file.getBasePath() + "/" + locale + " obtained from cache"));
                return file;
            }
            File result = (File)invocation.invokeNext();
            if (result != null) {
                this.log.trace((Object)(path + "/" + locale + " written to cache"));
                this.cache.put(path, locale, result);
            }
            return result;
        }
        this.log.trace((Object)("Command not trapped by the cache interceptor: " + invocation));
        return invocation.invokeNext();
    }
}

