/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.interceptors;

import java.lang.reflect.Method;
import java.util.Date;
import org.jboss.portal.cms.CMSInterceptor;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.JCRCommandContext;
import org.jboss.portal.cms.impl.jcr.composite.NewFileCommand;
import org.jboss.portal.cms.impl.jcr.composite.UpdateFileCommand;
import org.jboss.portal.cms.workflow.ApprovePublish;
import org.jboss.portal.cms.workflow.Content;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.identity.User;
import org.jboss.portal.jems.as.JNDI;

public class ApprovalWorkflowInterceptor
extends CMSInterceptor {
    private String jndiName = null;
    private JNDI.Binding jndiBinding = null;

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    protected Object invoke(JCRCommand invocation) throws Exception, InvocationException {
        ApprovePublish approvePublishWorkflow;
        if ((invocation instanceof NewFileCommand || invocation instanceof UpdateFileCommand) && (approvePublishWorkflow = (ApprovePublish)invocation.getContext().getAttribute(JCRCommandContext.scope, (Object)"approvePublishWorkflow")) != null) {
            User user = (User)invocation.getContext().getAttribute(JCRCommandContext.scope, (Object)"user");
            org.jboss.portal.cms.model.Content content = null;
            Method getContentMethod = invocation.getClass().getMethod("getContent", null);
            content = (org.jboss.portal.cms.model.Content)getContentMethod.invoke((Object)invocation, null);
            Content workflowContent = new Content();
            workflowContent.setPath(content.getBasePath());
            workflowContent.setUserName(user.getUserName());
            workflowContent.setMimeType(content.getMimeType());
            if (content.getBytes() != null) {
                workflowContent.setSize(content.getBytes().length);
            }
            workflowContent.setCreationDate(new Date());
            long processId = approvePublishWorkflow.requestApproval(workflowContent);
            invocation.setAttribute(JCRCommandContext.scope, "processid", String.valueOf(processId));
        }
        Object returnVal = invocation.invokeNext();
        return returnVal;
    }

    public void start() throws Exception {
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
    }

    public void stop() throws Exception {
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
    }
}

