/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.impl.interceptors;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.jboss.portal.cms.CMSException;
import org.jboss.portal.cms.CMSInterceptor;
import org.jboss.portal.cms.impl.jcr.JCRCMS;
import org.jboss.portal.cms.impl.jcr.JCRCommand;
import org.jboss.portal.cms.impl.jcr.command.SearchCommand;
import org.jboss.portal.cms.model.CMSObject;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.model.Folder;
import org.jboss.portal.cms.security.AuthorizationManager;
import org.jboss.portal.cms.security.CMSPermission;
import org.jboss.portal.cms.security.Criteria;
import org.jboss.portal.cms.security.PermRoleAssoc;
import org.jboss.portal.cms.security.Permission;
import org.jboss.portal.cms.security.PortalCMSSecurityContext;
import org.jboss.portal.cms.util.HibernateUtil;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.User;
import org.jboss.portal.jems.as.JNDI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ACLInterceptor
extends CMSInterceptor {
    private static Logger log = Logger.getLogger(ACLInterceptor.class);
    private String defaultPolicy = null;
    private RoleModule roleModule = null;
    private String jndiName = null;
    private JNDI.Binding jndiBinding = null;
    private AuthorizationManager authorizationManager = null;
    private String cmsSessionFactory = null;
    private String identitySessionFactory = null;
    private static ThreadLocal turnOff = new ThreadLocal();

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public void setDefaultPolicy(String defaultPolicy) {
        this.defaultPolicy = defaultPolicy;
    }

    public RoleModule getRoleModule() {
        return this.roleModule;
    }

    public void setRoleModule(RoleModule roleModule) {
        this.roleModule = roleModule;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getIdentitySessionFactory() {
        return this.identitySessionFactory;
    }

    public void setIdentitySessionFactory(String identitySessionFactory) {
        this.identitySessionFactory = identitySessionFactory;
    }

    public String getCmsSessionFactory() {
        return this.cmsSessionFactory;
    }

    public void setCmsSessionFactory(String cmsSessionFactory) {
        this.cmsSessionFactory = cmsSessionFactory;
    }

    public static void turnOff() {
        turnOff.set(new Boolean(true));
    }

    public static void turnOn() {
        turnOff.set(null);
    }

    public void start() throws Exception {
        log.info((Object)("AuthorizationManager initialized=" + this.authorizationManager));
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
        try {
            this.roleModule = (RoleModule)new InitialContext().lookup("java:portal/RoleModule");
        }
        catch (NamingException e) {
            log.error((Object)"Cannot obtain RoleModule from JNDI: ", (Throwable)e);
            throw e;
        }
        if (!this.isBootRequired()) {
            return;
        }
        this.initBootPolicy();
    }

    public void stop() throws Exception {
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
    }

    protected Object invoke(JCRCommand invocation) throws Exception, InvocationException {
        if (turnOff.get() == null) {
            User user = (User)JCRCMS.getUserInfo().get();
            PortalCMSSecurityContext securityContext = new PortalCMSSecurityContext(user);
            securityContext.setAttribute("command", invocation);
            CMSPermission cmsPermission = new CMSPermission(securityContext);
            boolean allowAccess = this.authorizationManager.checkPermission(cmsPermission);
            if (allowAccess) {
                Object response = invocation.invokeNext();
                response = this.applyFilter(response, securityContext);
                return response;
            }
            String username = null;
            username = user == null ? "Anonymous" : user.getUserName();
            log.debug((Object)("Unauthorized command (" + invocation + ") for user: " + username));
            throw new CMSException("Access to this resource is denied");
        }
        return invocation.invokeNext();
    }

    private Object applyFilter(Object response, PortalCMSSecurityContext securityContext) {
        ArrayList<File> filteredResponse = response;
        JCRCommand command = (JCRCommand)securityContext.getAttribute("command");
        try {
            if (JCRCMS.isUISecurityFilterActive() && filteredResponse instanceof Folder) {
                boolean allow;
                CMSPermission cmsPermission;
                Folder folder = (Folder)((Object)filteredResponse);
                ArrayList<CMSObject> filteredFolders = new ArrayList<CMSObject>();
                ArrayList<CMSObject> filteredFiles = new ArrayList<CMSObject>();
                securityContext.removeAttribute("command");
                if (folder.getFolders() != null) {
                    for (CMSObject cour : folder.getFolders()) {
                        securityContext.setAttribute("applyFilter", cour.getBasePath());
                        securityContext.setAttribute("isFolder", Boolean.TRUE);
                        cmsPermission = new CMSPermission(securityContext);
                        allow = this.authorizationManager.checkPermission(cmsPermission);
                        if (!allow) continue;
                        filteredFolders.add(cour);
                    }
                }
                if (folder.getFiles() != null) {
                    for (CMSObject cour : folder.getFiles()) {
                        securityContext.setAttribute("applyFilter", cour.getBasePath());
                        securityContext.setAttribute("isFolder", Boolean.FALSE);
                        cmsPermission = new CMSPermission(securityContext);
                        allow = this.authorizationManager.checkPermission(cmsPermission);
                        if (!allow) continue;
                        filteredFiles.add(cour);
                    }
                }
                folder.setFolders(filteredFolders);
                folder.setFiles(filteredFiles);
            }
            if (filteredResponse instanceof List && command instanceof SearchCommand) {
                List list = filteredResponse;
                ArrayList<File> filteredFiles = new ArrayList<File>();
                for (File cour : list) {
                    securityContext.setAttribute("path", cour.getBasePath());
                    CMSPermission cmsPermission = new CMSPermission(securityContext);
                    boolean allow = this.authorizationManager.checkPermission(cmsPermission);
                    if (!allow) continue;
                    filteredFiles.add(cour);
                }
                filteredResponse = filteredFiles;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return filteredResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBootPolicy() throws Exception {
        InputStream is = null;
        try {
            is = new ByteArrayInputStream(this.defaultPolicy.getBytes());
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
            NodeList criteria = document.getElementsByTagName("criteria");
            if (criteria != null) {
                for (int i = 0; i < criteria.getLength(); ++i) {
                    Element criteriaElem = (Element)criteria.item(i);
                    String name = criteriaElem.getAttribute("name");
                    String value = criteriaElem.getAttribute("value");
                    NodeList permissions = criteriaElem.getElementsByTagName("permission");
                    if (permissions == null) continue;
                    Session session = null;
                    Transaction tx = null;
                    Collection parsedPermissions = this.parseDefaultPermissions(permissions);
                    try {
                        session = HibernateUtil.getSessionFactory(this.cmsSessionFactory).openSession();
                        tx = session.beginTransaction();
                        for (Permission permission : parsedPermissions) {
                            permission.addCriteria(new Criteria(name, value));
                            HashSet<Permission> securityBinding = new HashSet<Permission>();
                            securityBinding.add(permission);
                            this.authorizationManager.getProvider().setSecurityBindings(null, securityBinding);
                        }
                        tx.commit();
                        continue;
                    }
                    catch (Exception e) {
                        if (tx == null) continue;
                        tx.rollback();
                        continue;
                    }
                    finally {
                        if (session != null && session.isOpen()) {
                            session.close();
                        }
                    }
                }
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private Collection parseDefaultPermissions(NodeList permissions) throws Exception {
        ArrayList<Permission> parsedPermissions = new ArrayList<Permission>();
        for (int i = 0; i < permissions.getLength(); ++i) {
            Element permissionElement = (Element)permissions.item(i);
            String name = permissionElement.getAttribute("name");
            String action = permissionElement.getAttribute("action");
            Permission permission = new Permission(name, action);
            NodeList roles = permissionElement.getElementsByTagName("role");
            for (int j = 0; j < roles.getLength(); ++j) {
                Element roleElement = (Element)roles.item(j);
                String roleName = roleElement.getAttribute("name");
                Role role = this.getRole(roleName);
                PermRoleAssoc roleAssoc = new PermRoleAssoc();
                if (role != null) {
                    roleAssoc.setRoleId(roleName);
                } else {
                    roleAssoc.setRoleId("Anonymous");
                }
                permission.addRoleAssoc(roleAssoc);
            }
            parsedPermissions.add(permission);
        }
        return parsedPermissions;
    }

    private Role getRole(String name) throws Exception {
        Role role = null;
        InitialContext context = new InitialContext();
        SessionFactory sessionFactory = (SessionFactory)context.lookup(this.identitySessionFactory);
        Session session = sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        try {
            role = this.roleModule.findRoleByName(name);
            tx.commit();
        }
        catch (IdentityException ie) {
            if (tx != null) {
                tx.rollback();
            }
            Role role2 = null;
            return role2;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            log.error((Object)this, (Throwable)e);
            throw e;
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBootRequired() {
        boolean bootRequired = false;
        String hsqlQuery = "select count(permission) from org.jboss.portal.cms.security.Permission as permission";
        Session session = HibernateUtil.getSessionFactory(this.cmsSessionFactory).openSession();
        Transaction tx = session.beginTransaction();
        try {
            Query query = session.createQuery(hsqlQuery);
            long count = (Long)query.list().get(0);
            if (count <= 0L) {
                bootRequired = true;
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return bootRequired;
    }
}

