/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.cms.hibernate;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Blob;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.jboss.logging.Logger;
import org.jboss.portal.cms.hibernate.CMSEntry;
import org.jboss.portal.cms.hibernate.RepositoryEntry;
import org.jboss.portal.cms.hibernate.VersionEntry;
import org.jboss.portal.cms.util.HibernateUtil;
import org.jboss.portal.common.io.IOTools;

public class HibernateStore
implements FileSystem {
    private static Logger log = Logger.getLogger(HibernateStore.class);
    private SessionFactory hibernateSessionFactory;
    private String jndiName;
    protected boolean initialized = false;
    protected String schemaObjectPrefix;
    protected static final int INITIAL_BUFFER_SIZE = 8192;
    protected String selectExistStmt;
    protected String selectFolderExistStmt;
    protected String selectFileExistStmt;
    protected String selectChildCountStmt;
    protected String selectDataStmt;
    protected String selectLastModifiedStmt;
    protected String selectLengthStmt;
    protected String deleteFileStmt;
    protected String deleteFolderStmt;
    protected String insertFileStmt;

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String JNDIName) {
        this.jndiName = JNDIName;
    }

    public void init() throws FileSystemException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.hibernateSessionFactory = HibernateUtil.getSessionFactory(this.jndiName);
        this.selectExistStmt = "select 1 from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?";
        this.insertFileStmt = "insert into " + this.schemaObjectPrefix + " (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, " + "FSENTRY_LASTMOD, FSENTRY_LENGTH) " + "values (?, ?, ?, ?, ?)";
        this.selectFileExistStmt = "select 1 from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.selectFolderExistStmt = "select 1 from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is null";
        this.selectChildCountStmt = "select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ?";
        this.selectDataStmt = "select data from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.selectLastModifiedStmt = "select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ?";
        this.selectLengthStmt = "select FSENTRY_LENGTH from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ? " + "and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.initialized = true;
    }

    public void close() throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        this.initialized = false;
    }

    public void createFolder(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)folderPath);
        if (this.exists(folderPath)) {
            throw new FileSystemException("file system entry already exists: " + folderPath);
        }
        this.createDeepFolder(folderPath);
    }

    public void deleteFile(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)filePath);
        String parentDir = FileSystemPathUtil.getParentDir((String)filePath);
        String name = FileSystemPathUtil.getName((String)filePath);
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            String query = "from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
            List result = session.createQuery(query).setString(0, parentDir).setString(1, name).list();
            if (result.size() == 0) {
                throw new FileSystemException("no such file: " + filePath);
            }
            if (this.schemaObjectPrefix.equals("VersionEntry")) {
                for (VersionEntry versionEntry : result) {
                    session.delete((Object)versionEntry);
                }
            } else if (this.schemaObjectPrefix.equals("CMSEntry")) {
                for (CMSEntry cmsEntry : result) {
                    session.delete((Object)cmsEntry);
                }
            } else if (this.schemaObjectPrefix.equals("RepositoryEntry")) {
                for (RepositoryEntry repoEntry : result) {
                    session.delete((Object)repoEntry);
                }
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to delete file: " + filePath;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public void deleteFolder(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)folderPath);
        if (folderPath.equals("/")) {
            throw new FileSystemException("cannot delete root");
        }
        String parentDir = FileSystemPathUtil.getParentDir((String)folderPath);
        String name = FileSystemPathUtil.getName((String)folderPath);
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            String query = "from " + this.schemaObjectPrefix + " where FSENTRY_PATH = ? and FSENTRY_NAME = ? " + "and FSENTRY_DATA is null or (FSENTRY_PATH = ?) or (FSENTRY_PATH like ?)";
            List result = session.createQuery(query).setString(0, parentDir).setString(1, name).setString(2, folderPath).setString(3, folderPath + "/" + "%").list();
            if (result.size() == 0) {
                throw new FileSystemException("no such folder: " + folderPath);
            }
            if (this.schemaObjectPrefix.equals("VersionEntry")) {
                for (VersionEntry versionEntry : result) {
                    session.delete((Object)versionEntry);
                }
            } else if (this.schemaObjectPrefix.equals("CMSEntry")) {
                for (CMSEntry cmsEntry : result) {
                    session.delete((Object)cmsEntry);
                }
            } else if (this.schemaObjectPrefix.equals("RepositoryEntry")) {
                for (RepositoryEntry repoEntry : result) {
                    session.delete((Object)repoEntry);
                }
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to delete folder: " + folderPath;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public boolean exists(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)path);
        String parentDir = FileSystemPathUtil.getParentDir((String)path);
        String name = FileSystemPathUtil.getName((String)path);
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            List rs = session.createQuery(this.selectExistStmt).setString(0, parentDir).setString(1, name).list();
            Iterator iter = rs.iterator();
            if (iter.hasNext()) {
                return true;
            }
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to check existence of file system entry: " + path;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
        return false;
    }

    public boolean isFile(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)path);
        String parentDir = FileSystemPathUtil.getParentDir((String)path);
        String name = FileSystemPathUtil.getName((String)path);
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            List rs = session.createQuery(this.selectFileExistStmt).setString(0, parentDir).setString(1, name).list();
            Iterator iter = rs.iterator();
            return iter.hasNext();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to check existence of file: " + path;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public boolean isFolder(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)path);
        String parentDir = FileSystemPathUtil.getParentDir((String)path);
        String name = FileSystemPathUtil.getName((String)path);
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            List rs = session.createQuery(this.selectFolderExistStmt).setString(0, parentDir).setString(1, name).list();
            Iterator iter = rs.iterator();
            return iter.hasNext();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to check existence of folder: " + path;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public long lastModified(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)path);
        String parentDir = FileSystemPathUtil.getParentDir((String)path);
        String name = FileSystemPathUtil.getName((String)path);
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            List rs = session.createQuery(this.selectLastModifiedStmt).setString(0, parentDir).setString(1, name).list();
            if (rs.size() == 0) {
                throw new FileSystemException("no such file system entry: " + path);
            }
            Iterator iter = rs.iterator();
            return (Long)iter.next();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to determine lastModified of file system entry: " + path;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public long length(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)filePath);
        String parentDir = FileSystemPathUtil.getParentDir((String)filePath);
        String name = FileSystemPathUtil.getName((String)filePath);
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            List rs = session.createQuery(this.selectLengthStmt).setString(0, parentDir).setString(1, name).list();
            if (rs.size() == 0) {
                throw new FileSystemException("no such file system entry: " + filePath);
            }
            Iterator iter = rs.iterator();
            return (Long)iter.next();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to determine length of file: " + filePath;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public boolean hasChildren(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)path);
        if (!this.exists(path)) {
            throw new FileSystemException("no such file system entry: " + path);
        }
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            List rs = session.createQuery(this.selectChildCountStmt).setString(0, path).list();
            if (rs.size() == 0) {
                return false;
            }
            Iterator iter = rs.iterator();
            int count = (Integer)iter.next();
            if (FileSystemPathUtil.denotesRoot((String)path)) {
                --count;
            }
            return count > 0;
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to determine child count of file system entry: " + path;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public String[] list(String folderPath) throws FileSystemException {
        throw new RuntimeException("Not Yet Implemented");
    }

    public String[] listFiles(String folderPath) throws FileSystemException {
        throw new RuntimeException("Not Yet Implemented");
    }

    public String[] listFolders(String folderPath) throws FileSystemException {
        throw new RuntimeException("Not Yet Implemented");
    }

    public void touch(String filePath) throws FileSystemException {
        throw new RuntimeException("Not Yet Implemented");
    }

    public InputStream getInputStream(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)filePath);
        String parentDir = FileSystemPathUtil.getParentDir((String)filePath);
        String name = FileSystemPathUtil.getName((String)filePath);
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            Query query = session.createQuery(this.selectDataStmt).setString(0, parentDir).setString(1, name);
            List rs = query.list();
            Iterator iter = rs.iterator();
            Blob blob = (Blob)iter.next();
            return new ByteArrayInputStream(IOTools.getBytes((InputStream)blob.getBinaryStream()));
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to retrieve data of file: " + filePath;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public OutputStream getOutputStream(final String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)filePath);
        final String parentDir = FileSystemPathUtil.getParentDir((String)filePath);
        final String name = FileSystemPathUtil.getName((String)filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            return new FilterOutputStream(new FileOutputStream(tmpFile)){
                File f;
                {
                    super(x0);
                    this.f = tmpFile;
                }

                public void close() throws IOException {
                    InputStream in;
                    block22: {
                        super.close();
                        in = null;
                        try {
                            if (HibernateStore.this.isFile(filePath)) {
                                Session session = HibernateStore.this.hibernateSessionFactory.getCurrentSession();
                                session.beginTransaction();
                                try {
                                    long length = this.f.length();
                                    in = IOTools.safeBufferedWrapper((InputStream)new FileInputStream(this.f));
                                    if (HibernateStore.this.schemaObjectPrefix.equals("VersionEntry")) {
                                        Query query = session.createQuery("from VersionEntry where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
                                        query.setString(0, parentDir);
                                        query.setString(1, name);
                                        VersionEntry versionEntry = (VersionEntry)query.uniqueResult();
                                        if (versionEntry == null) {
                                            throw new Exception("No such Entry " + name);
                                        }
                                        versionEntry.setData(Hibernate.createBlob((InputStream)in));
                                        versionEntry.setLastmod(System.currentTimeMillis());
                                        versionEntry.setLength(length);
                                        session.save((Object)versionEntry);
                                        session.flush();
                                    } else if (HibernateStore.this.schemaObjectPrefix.equals("CMSEntry")) {
                                        Query query = session.createQuery("from CMSEntry where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
                                        query.setString(0, parentDir);
                                        query.setString(1, name);
                                        CMSEntry cmsEntry = (CMSEntry)query.uniqueResult();
                                        if (cmsEntry == null) {
                                            throw new Exception("No such Entry " + name);
                                        }
                                        cmsEntry.setData(Hibernate.createBlob((InputStream)in));
                                        cmsEntry.setLastmod(System.currentTimeMillis());
                                        cmsEntry.setLength(length);
                                        session.save((Object)cmsEntry);
                                        session.flush();
                                    } else if (HibernateStore.this.schemaObjectPrefix.equals("RepositoryEntry")) {
                                        Query query = session.createQuery("from RepositoryEntry where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
                                        query.setString(0, parentDir);
                                        query.setString(1, name);
                                        RepositoryEntry repoEntry = (RepositoryEntry)query.uniqueResult();
                                        if (repoEntry == null) {
                                            throw new Exception("No such Entry " + name);
                                        }
                                        repoEntry.setData(Hibernate.createBlob((InputStream)in));
                                        repoEntry.setLastmod(System.currentTimeMillis());
                                        repoEntry.setLength(length);
                                        session.save((Object)repoEntry);
                                        session.flush();
                                    }
                                    session.getTransaction().commit();
                                    break block22;
                                }
                                catch (Exception e) {
                                    session.getTransaction().rollback();
                                    String msg = "failed to update existing file: " + filePath;
                                    log.error((Object)msg, (Throwable)e);
                                    throw new FileSystemException(msg, (Throwable)e);
                                }
                            }
                            Session session = HibernateStore.this.hibernateSessionFactory.getCurrentSession();
                            session.beginTransaction();
                            try {
                                long length = this.f.length();
                                in = new FileInputStream(this.f);
                                if (HibernateStore.this.schemaObjectPrefix.equals("VersionEntry")) {
                                    VersionEntry versionEntry = new VersionEntry(parentDir, name, Hibernate.createBlob((InputStream)in), System.currentTimeMillis(), length);
                                    session.save((Object)versionEntry);
                                    session.flush();
                                } else if (HibernateStore.this.schemaObjectPrefix.equals("CMSEntry")) {
                                    CMSEntry cmsEntry = new CMSEntry(parentDir, name, Hibernate.createBlob((InputStream)in), System.currentTimeMillis(), length);
                                    session.save((Object)cmsEntry);
                                    session.flush();
                                } else if (HibernateStore.this.schemaObjectPrefix.equals("RepositoryEntry")) {
                                    RepositoryEntry repoEntry = new RepositoryEntry(parentDir, name, Hibernate.createBlob((InputStream)in), System.currentTimeMillis(), length);
                                    session.save((Object)repoEntry);
                                    session.flush();
                                }
                                session.getTransaction().commit();
                            }
                            catch (Exception e) {
                                session.getTransaction().rollback();
                                String msg = "failed to create new file: " + filePath;
                                log.error((Object)msg, (Throwable)e);
                                throw new FileSystemException(msg, (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            try {
                                throw new IOException(e.getMessage());
                            }
                            catch (Throwable throwable) {
                                IOTools.safeClose(in);
                                this.f.delete();
                                this.f = null;
                                throw throwable;
                            }
                        }
                    }
                    IOTools.safeClose((Closeable)in);
                    this.f.delete();
                    this.f = null;
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output strean to file: " + filePath;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessOutputStream getRandomAccessOutputStream(final String filePath) throws FileSystemException, UnsupportedOperationException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)filePath);
        final String parentDir = FileSystemPathUtil.getParentDir((String)filePath);
        final String name = FileSystemPathUtil.getName((String)filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            if (this.isFile(filePath)) {
                InputStream in = this.getInputStream(filePath);
                FileOutputStream out = new FileOutputStream(tmpFile);
                try {
                    int read;
                    byte[] ba = new byte[8192];
                    while ((read = in.read(ba, 0, ba.length)) != -1) {
                        ((OutputStream)out).write(ba, 0, read);
                    }
                }
                finally {
                    IOTools.safeClose((Closeable)out);
                }
            }
            return new RandomAccessOutputStream(){
                File f;
                RandomAccessFile raf;
                {
                    this.f = tmpFile;
                    this.raf = new RandomAccessFile(this.f, "rw");
                }

                public void close() throws IOException {
                    BufferedInputStream in;
                    block22: {
                        this.raf.close();
                        in = null;
                        try {
                            if (HibernateStore.this.isFile(filePath)) {
                                Session session = HibernateStore.this.hibernateSessionFactory.getCurrentSession();
                                session.beginTransaction();
                                try {
                                    long length = this.f.length();
                                    in = IOTools.safeBufferedWrapper((InputStream)new FileInputStream(this.f));
                                    if (HibernateStore.this.schemaObjectPrefix.equals("VersionEntry")) {
                                        Query query = session.createQuery("from VersionEntry where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
                                        query.setString(0, parentDir);
                                        query.setString(1, name);
                                        VersionEntry versionEntry = (VersionEntry)query.uniqueResult();
                                        if (versionEntry == null) {
                                            throw new Exception("No such Entry " + name);
                                        }
                                        versionEntry.setData(Hibernate.createBlob((InputStream)in));
                                        versionEntry.setLastmod(System.currentTimeMillis());
                                        versionEntry.setLength(length);
                                        session.save((Object)versionEntry);
                                        session.flush();
                                    } else if (HibernateStore.this.schemaObjectPrefix.equals("CMSEntry")) {
                                        Query query = session.createQuery("from CMSEntry where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
                                        query.setString(0, parentDir);
                                        query.setString(1, name);
                                        CMSEntry cmsEntry = (CMSEntry)query.uniqueResult();
                                        if (cmsEntry == null) {
                                            throw new Exception("No such Entry " + name);
                                        }
                                        cmsEntry.setData(Hibernate.createBlob((InputStream)in));
                                        cmsEntry.setLastmod(System.currentTimeMillis());
                                        cmsEntry.setLength(length);
                                        session.save((Object)cmsEntry);
                                        session.flush();
                                    } else if (HibernateStore.this.schemaObjectPrefix.equals("RepositoryEntry")) {
                                        Query query = session.createQuery("from CMSEntry where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null");
                                        query.setString(0, parentDir);
                                        query.setString(1, name);
                                        RepositoryEntry repoEntry = (RepositoryEntry)query.uniqueResult();
                                        if (repoEntry == null) {
                                            throw new Exception("No such Entry " + name);
                                        }
                                        repoEntry.setData(Hibernate.createBlob((InputStream)in));
                                        repoEntry.setLastmod(System.currentTimeMillis());
                                        repoEntry.setLength(length);
                                        session.save((Object)repoEntry);
                                        session.flush();
                                    }
                                    session.getTransaction().commit();
                                    break block22;
                                }
                                catch (Exception e) {
                                    session.getTransaction().rollback();
                                    String msg = "failed to update existing file: " + filePath;
                                    log.error((Object)msg, (Throwable)e);
                                    throw new FileSystemException(msg, (Throwable)e);
                                }
                            }
                            Session session = HibernateStore.this.hibernateSessionFactory.getCurrentSession();
                            session.beginTransaction();
                            try {
                                long length = this.f.length();
                                in = IOTools.safeBufferedWrapper((InputStream)new FileInputStream(this.f));
                                if (HibernateStore.this.schemaObjectPrefix.equals("VersionEntry")) {
                                    VersionEntry versionEntry = new VersionEntry(parentDir, name, Hibernate.createBlob((InputStream)in), System.currentTimeMillis(), length);
                                    session.save((Object)versionEntry);
                                    session.flush();
                                } else if (HibernateStore.this.schemaObjectPrefix.equals("CMSEntry")) {
                                    CMSEntry cmsEntry = new CMSEntry(parentDir, name, Hibernate.createBlob((InputStream)in), System.currentTimeMillis(), length);
                                    session.save((Object)cmsEntry);
                                    session.flush();
                                } else if (HibernateStore.this.schemaObjectPrefix.equals("RepositoryEntry")) {
                                    RepositoryEntry repoEntry = new RepositoryEntry(parentDir, name, Hibernate.createBlob((InputStream)in), System.currentTimeMillis(), length);
                                    session.save((Object)repoEntry);
                                    session.flush();
                                }
                                session.getTransaction().commit();
                            }
                            catch (Exception e) {
                                session.getTransaction().rollback();
                                String msg = "failed to create new file: " + filePath;
                                log.error((Object)msg, (Throwable)e);
                                throw new FileSystemException(msg, (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            try {
                                throw new IOException(e.getMessage());
                            }
                            catch (Throwable throwable) {
                                IOTools.safeClose(in);
                                this.f.delete();
                                this.f = null;
                                this.raf = null;
                                throw throwable;
                            }
                        }
                    }
                    IOTools.safeClose((Closeable)in);
                    this.f.delete();
                    this.f = null;
                    this.raf = null;
                }

                public void seek(long position) throws IOException {
                    this.raf.seek(position);
                }

                public void write(int b) throws IOException {
                    this.raf.write(b);
                }

                public void flush() {
                }

                public void write(byte[] b) throws IOException {
                    this.raf.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    this.raf.write(b, off, len);
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output strean to file: " + filePath;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    public void copy(String srcPath, String destPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)srcPath);
        FileSystemPathUtil.checkFormat((String)destPath);
        if (this.isFolder(srcPath)) {
            this.copyDeepFolder(srcPath, destPath);
        } else {
            this.copyFile(srcPath, destPath);
        }
    }

    public void move(String srcPath, String destPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat((String)srcPath);
        FileSystemPathUtil.checkFormat((String)destPath);
        this.copy(srcPath, destPath);
        if (this.isFile(srcPath)) {
            this.deleteFile(srcPath);
        } else {
            this.deleteFolder(srcPath);
        }
    }

    protected void checkSchema() throws Exception {
        throw new RuntimeException("Not Yet Implemented");
    }

    protected void verifyRootExists() throws Exception {
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            List rs = session.createQuery(this.selectFolderExistStmt).setString(1, "/").setString(2, "").list();
            Iterator iter = rs.iterator();
            if (iter.hasNext()) {
                return;
            }
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to check existence of file system root entry";
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
        this.createDeepFolder("/");
    }

    protected void createDeepFolder(String folderPath) throws FileSystemException {
        String parentDir = FileSystemPathUtil.getParentDir((String)folderPath);
        String name = FileSystemPathUtil.getName((String)folderPath);
        if (!FileSystemPathUtil.denotesRoot((String)folderPath) && !this.exists(parentDir)) {
            this.createDeepFolder(parentDir);
        }
        Session session = this.hibernateSessionFactory.getCurrentSession();
        session.beginTransaction();
        try {
            if (this.schemaObjectPrefix.equals("VersionEntry")) {
                VersionEntry versionEntry = new VersionEntry(parentDir, name, null, System.currentTimeMillis(), 0L);
                session.save((Object)versionEntry);
                session.flush();
            } else if (this.schemaObjectPrefix.equals("CMSEntry")) {
                CMSEntry cmsEntry = new CMSEntry(parentDir, name, null, System.currentTimeMillis(), 0L);
                session.save((Object)cmsEntry);
            } else if (this.schemaObjectPrefix.equals("RepositoryEntry")) {
                RepositoryEntry repoEntry = new RepositoryEntry(parentDir, name, null, System.currentTimeMillis(), 0L);
                session.save((Object)repoEntry);
                session.flush();
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            String msg = "failed to create folder entry: " + folderPath;
            log.error((Object)msg, (Throwable)e);
            throw new FileSystemException(msg, (Throwable)e);
        }
    }

    protected void copyDeepFolder(String srcPath, String destPath) throws FileSystemException {
        throw new RuntimeException("Not Yet Implemented");
    }

    protected void copyFile(String srcPath, String destPath) throws FileSystemException {
        throw new RuntimeException("Not Yet Implemented");
    }
}

