/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.workflow;

import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.taskmgmt.def.AssignmentHandler;
import org.jbpm.taskmgmt.exe.Assignable;
import org.jbpm.taskmgmt.exe.TaskInstance;

import java.util.Collection;


/**
 * Created on : Dec 20, 2006
 *
 * @author Sohil Shah - sohil.shah@jboss.com
 */
public class PublishAssignmentHandler implements AssignmentHandler
{
   // private static Logger log = Logger.getLogger(PublishAssignmentHandler.class);

   /**
    *
    */
   public void assign(Assignable assignable, ExecutionContext executionContext)
   {
      int taskInstances = 0;
      Collection assignedTasks = executionContext.getTaskMgmtInstance().getTaskInstances();
      if (assignedTasks != null)
      {
         taskInstances = assignedTasks.size();
      }

      if (taskInstances == 1)
      {
         String[] managers = (String[])executionContext.getContextInstance().getVariable("managers");
         if (managers != null && managers.length > 0)
         {
            //this.notifyManagers(executionContext,managers[0]);
            assignable.setActorId(managers[0]);

            for (int i = 1; i < managers.length; i++)
            {
               //this.notifyManagers(executionContext,managers[i]);
               TaskInstance t = executionContext.getTaskMgmtInstance().
                  createTaskInstance(((TaskInstance)assignable).getTask(), executionContext);
               t.setActorId(managers[i]);
            }
         }
      }
   }
}
