/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.workflow;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Locale;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;

import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.portal.cms.CMS;
import org.jboss.portal.cms.Command;
import org.jboss.portal.cms.model.Content;
import org.jboss.portal.cms.model.File;
import org.jboss.portal.cms.impl.interceptors.ACLInterceptor;
import org.jbpm.bytes.ByteArray;

/**
 * @author Sohil Shah - sshah@redhat.com
 */
public class CMSWorkflowUtil
{
   /**
    * 
    * @return
    */
   public static Content getPendingContent(long processId, String contentPath)
   {
      Content content = null;
      
      int lastIndex = contentPath.lastIndexOf('/');
      String path = contentPath.substring(0, lastIndex);
      String language = contentPath.substring(lastIndex + 1);
      
      ACLInterceptor.turnOff();
      
      CMS cms = CMSWorkflowUtil.getCMSService();
      Command command = cms.getCommandFactory().createContentGetVersionsCommand(contentPath);
      List versions = (List)cms.execute(command);
      
      content = CMSWorkflowUtil.findProcessContent(processId, versions);
      if(content != null)
      {
         //fetch the content
         command = cms.getCommandFactory().createFileGetCommand(path, content.getVersionNumber(), new Locale(language));
         File file = (File)cms.execute(command);
         
         content = file.getContent();
      }
      
      
      ACLInterceptor.turnOn();
      
      return content;
   }
   
   /**
    * @param processId
    * @param versions
    * @return
    */
   private static Content findProcessContent(long processId, List versions)
   {
      Content content = null;

      if (versions != null)
      {
         for (int i = 0; i < versions.size(); i++)
         {
            Content cour = (org.jboss.portal.cms.model.Content)versions.get(i);
            if (cour.isWaitingForPublishApproval())
            {
               if (cour.getApprovalProcessId() != null &&
                  cour.getApprovalProcessId().trim().equals(String.valueOf(processId)))
               {
                  //not if found...the content of this version should be published to go live
                  return cour;
               }
            }
         }
      }

      return content;
   }
   
   /** @return  */
   public static CMS getCMSService()
   {
      CMS cms = null;
      try
      {
         MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
         cms =  (CMS)MBeanProxy.get(CMS.class, new ObjectName("portal:service=CMS"), mbeanServer);
      }
      catch (Exception e)
      {         
         try
         {
            //Give it a last try and look up in the JNDI tree (this happens in the test suite, where there is no mbean server)
            cms = (CMS)new InitialContext().lookup("java:/portal/CMS");
         }
         catch(Exception ex)
         {
            //This failed too....This is a real failure and throw an exception
            throw new RuntimeException(ex);
         }
      }
      return cms;
   }
   
   public static org.jboss.portal.cms.workflow.Content deserializeContent(Object object) throws Exception
   {
      org.jboss.portal.cms.workflow.Content content = null;
      
      if(object instanceof ByteArray)
      {         
         //JBPM bug workaround: https://jira.jboss.org/jira/browse/JBPM-1914
         byte[] objectBytes = ((ByteArray)object).getBytes();
         
         content = (org.jboss.portal.cms.workflow.Content)(new ObjectInputStream(new ByteArrayInputStream(objectBytes))).readObject();
      }
      else if(object instanceof org.jboss.portal.cms.workflow.Content)
      {
         content = (org.jboss.portal.cms.workflow.Content)object;
      }
      
      return content;
   }
}
