/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.portal.cms.workflow;

import org.jboss.portal.workflow.WorkflowException;

import java.util.Collection;
import java.util.Set;

/**
 * Created on : Dec 19, 2006
 *
 * @author Sohil Shah - sohil.shah@jboss.com
 */
public interface ApprovePublish
{
   /**
    * Called when content is added to the CMS, and needs to be approved by the managers before it can be published to go
    * live
    *
    * @param content the content to be approved
    * @return the process id of the workflow process set in motion
    * @throws WorkflowException if an error occured during the approval process
    */
   public long requestApproval(Content content) throws WorkflowException;

   /**
    * Called when a manager either approves or rejects the publishing of a specific content to go live
    *
    * @param processId the id of the approval process we are interested in
    * @param manager   userId of the manager
    * @param approved  true if approved, false if rejected
    */
   public void processManagerResponse(long processId, String manager, boolean approved) throws WorkflowException;

    /**
    * Called when a manager either approves the publishing of a specific content to go live, but at the same time adds
    * his/her own modifications to the original content
    *
    * @param processId       the process id of the workflow we're interesting in
    * @param manager         userId of the manager
    * @param modifiedContent modified content
    */
   public void processManagerResponse(long processId, String manager, String modifiedContent) throws WorkflowException;

   /**
    * Retrieves a queue of unapproved content associated with the specified file in the CMS
    *
    * @param filePath
    * @return
    * @throws WorkflowException
    */
   public Collection<Content> getPendingQueue(String filePath) throws WorkflowException;

   /**
    * Retrieves a queue of unapproved content for everything in the CMS.
    *
    * @return
    * @throws WorkflowException
    */
   public Collection<Content> getAllPendingInQueue() throws WorkflowException;

   /**
    * Returns role names of Roles that are designated to be Managers in this workflow. Managers approve/deny all content
    * publish requests before the content goes live in the CMS
    *
    * @return a Set of role names
    */
   public Set<String> getManagers();
}
