/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/

package org.jboss.portal.cms.util;

import org.hibernate.Session;
import org.hibernate.SessionFactory;

import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HibernateUtil
{
   public static SessionFactory getSessionFactory(String jndiName)
   {
      if (jndiName == null)
      {
         throw new IllegalStateException("You need to specify a JNDI Name for the HibernateSessionFactory");
      }
      try
      {
         InitialContext ic = new InitialContext();
         return (SessionFactory)ic.lookup(jndiName);
      }
      catch (NamingException e)
      {
         throw new IllegalStateException("No HibernateSessionFactory can be found in the JNDI tree at: " + jndiName);
      }
   }
   
   /** @param session  */
   public static void closeSession(Session session)
   {
      if (session != null && session.isOpen())
      {
         session.close();
      }
   }
}
